/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.assigner;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.DataSourceDialect;
import org.apache.flink.cdc.connectors.base.source.assigner.AssignerStatus;
import org.apache.flink.cdc.connectors.base.source.assigner.SplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import org.apache.flink.cdc.connectors.base.source.assigner.state.SnapshotPendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotSplitAssigner<C extends SourceConfig>
implements SplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotSplitAssigner.class);
    private final List<TableId> alreadyProcessedTables;
    private final List<SchemalessSnapshotSplit> remainingSplits;
    private final Map<String, SchemalessSnapshotSplit> assignedSplits;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final Map<String, Offset> splitFinishedOffsets;
    private AssignerStatus assignerStatus;
    private final C sourceConfig;
    private final int currentParallelism;
    private final LinkedList<TableId> remainingTables;
    private final boolean isRemainingTablesCheckpointed;
    private ChunkSplitter chunkSplitter;
    private boolean isTableIdCaseSensitive;
    @Nullable
    private Long checkpointIdToFinish;
    private final DataSourceDialect<C> dialect;
    private final OffsetFactory offsetFactory;

    public SnapshotSplitAssigner(C sourceConfig, int currentParallelism, List<TableId> remainingTables, boolean isTableIdCaseSensitive, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this(sourceConfig, currentParallelism, new ArrayList<TableId>(), new ArrayList<SchemalessSnapshotSplit>(), new LinkedHashMap<String, SchemalessSnapshotSplit>(), new HashMap<TableId, TableChanges.TableChange>(), new HashMap<String, Offset>(), AssignerStatus.INITIAL_ASSIGNING, remainingTables, isTableIdCaseSensitive, true, dialect, offsetFactory);
    }

    public SnapshotSplitAssigner(C sourceConfig, int currentParallelism, SnapshotPendingSplitsState checkpoint, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this(sourceConfig, currentParallelism, checkpoint.getAlreadyProcessedTables(), checkpoint.getRemainingSplits(), checkpoint.getAssignedSplits(), checkpoint.getTableSchemas(), checkpoint.getSplitFinishedOffsets(), checkpoint.getSnapshotAssignerStatus(), checkpoint.getRemainingTables(), checkpoint.isTableIdCaseSensitive(), checkpoint.isRemainingTablesCheckpointed(), dialect, offsetFactory);
    }

    private SnapshotSplitAssigner(C sourceConfig, int currentParallelism, List<TableId> alreadyProcessedTables, List<SchemalessSnapshotSplit> remainingSplits, Map<String, SchemalessSnapshotSplit> assignedSplits, Map<TableId, TableChanges.TableChange> tableSchemas, Map<String, Offset> splitFinishedOffsets, AssignerStatus assignerStatus, List<TableId> remainingTables, boolean isTableIdCaseSensitive, boolean isRemainingTablesCheckpointed, DataSourceDialect<C> dialect, OffsetFactory offsetFactory) {
        this.sourceConfig = sourceConfig;
        this.currentParallelism = currentParallelism;
        this.alreadyProcessedTables = alreadyProcessedTables;
        this.remainingSplits = remainingSplits;
        this.assignedSplits = assignedSplits.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, o2) -> o, LinkedHashMap::new));
        this.tableSchemas = tableSchemas;
        this.splitFinishedOffsets = splitFinishedOffsets;
        this.assignerStatus = assignerStatus;
        this.remainingTables = new LinkedList<TableId>(remainingTables);
        this.isRemainingTablesCheckpointed = isRemainingTablesCheckpointed;
        this.isTableIdCaseSensitive = isTableIdCaseSensitive;
        this.dialect = dialect;
        this.offsetFactory = offsetFactory;
    }

    @Override
    public void open() {
        this.chunkSplitter = this.dialect.createChunkSplitter(this.sourceConfig);
        this.discoveryCaptureTables();
        this.captureNewlyAddedTables();
    }

    private void discoveryCaptureTables() {
        if (this.needToDiscoveryTables()) {
            long start = System.currentTimeMillis();
            LOG.debug("The remainingTables is empty, start to discovery tables");
            try {
                List<TableId> discoverTables = this.dialect.discoverDataCollections(this.sourceConfig);
                this.remainingTables.addAll(discoverTables);
                LOG.debug("Discovery tables success, time cost: {} ms.", (Object)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discovery tables to capture", (Throwable)e);
            }
        }
        if (!this.isRemainingTablesCheckpointed && !AssignerStatus.isSnapshotAssigningFinished(this.assignerStatus)) {
            try {
                List<TableId> discoverTables = this.dialect.discoverDataCollections(this.sourceConfig);
                discoverTables.removeAll(this.alreadyProcessedTables);
                this.remainingTables.addAll(discoverTables);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discover remaining tables to capture", (Throwable)e);
            }
        }
    }

    private void captureNewlyAddedTables() {
        if (this.sourceConfig.isScanNewlyAddedTableEnabled() && !this.sourceConfig.getStartupOptions().isSnapshotOnly()) {
            try {
                List<TableId> currentCapturedTables = this.dialect.discoverDataCollections(this.sourceConfig);
                HashSet<Object> previousCapturedTables = new HashSet<Object>();
                List tablesInRemainingSplits = this.remainingSplits.stream().map(SnapshotSplit::getTableId).collect(Collectors.toList());
                previousCapturedTables.addAll(tablesInRemainingSplits);
                previousCapturedTables.addAll(this.alreadyProcessedTables);
                previousCapturedTables.addAll(this.remainingTables);
                HashSet tablesToRemove = new HashSet(previousCapturedTables);
                tablesToRemove.removeAll(currentCapturedTables);
                currentCapturedTables.removeAll(previousCapturedTables);
                List<TableId> newlyAddedTables = currentCapturedTables;
                if (!tablesToRemove.isEmpty()) {
                    LinkedList<String> splitsToRemove = new LinkedList<String>();
                    for (Map.Entry<String, SchemalessSnapshotSplit> splitEntry : this.assignedSplits.entrySet()) {
                        if (!tablesToRemove.contains(splitEntry.getValue().getTableId())) continue;
                        splitsToRemove.add(splitEntry.getKey());
                    }
                    splitsToRemove.forEach(this.assignedSplits.keySet()::remove);
                    splitsToRemove.forEach(this.splitFinishedOffsets.keySet()::remove);
                    this.tableSchemas.entrySet().removeIf(schema -> tablesToRemove.contains(schema.getKey()));
                    LOG.info("Enumerator remove tables after restart: {}", tablesToRemove);
                    this.remainingSplits.removeIf(split -> tablesToRemove.contains(split.getTableId()));
                    this.remainingTables.removeAll(tablesToRemove);
                    this.alreadyProcessedTables.removeIf(tableId -> tablesToRemove.contains(tableId));
                }
                if (!newlyAddedTables.isEmpty()) {
                    LOG.info("Found newly added tables, start capture newly added tables process");
                    this.remainingTables.addAll(newlyAddedTables);
                    if (AssignerStatus.isAssigningFinished(this.assignerStatus)) {
                        LOG.info("Found newly added tables, start capture newly added tables process under stream reading phase");
                        this.startAssignNewlyAddedTables();
                    }
                }
            }
            catch (Exception e) {
                throw new FlinkRuntimeException("Failed to discover remaining tables to capture", (Throwable)e);
            }
        }
    }

    @Override
    public Optional<SourceSplitBase> getNext() {
        if (!this.remainingSplits.isEmpty()) {
            Iterator<SchemalessSnapshotSplit> iterator = this.remainingSplits.iterator();
            SchemalessSnapshotSplit split = iterator.next();
            iterator.remove();
            this.assignedSplits.put(split.splitId(), split);
            return Optional.of(split.toSnapshotSplit(this.tableSchemas.get(split.getTableId())));
        }
        TableId nextTable = this.remainingTables.pollFirst();
        if (nextTable != null) {
            Collection<SnapshotSplit> splits = this.chunkSplitter.generateSplits(nextTable);
            HashMap<TableId, TableChanges.TableChange> tableSchema = new HashMap<TableId, TableChanges.TableChange>();
            if (!splits.isEmpty()) {
                tableSchema.putAll(splits.iterator().next().getTableSchemas());
            }
            List schemalessSnapshotSplits = splits.stream().map(SnapshotSplit::toSchemalessSnapshotSplit).collect(Collectors.toList());
            this.remainingSplits.addAll(schemalessSnapshotSplits);
            this.tableSchemas.putAll(tableSchema);
            this.alreadyProcessedTables.add(nextTable);
            return this.getNext();
        }
        return Optional.empty();
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return !this.allSnapshotSplitsFinished();
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        if (this.waitingForFinishedSplits()) {
            LOG.error("The assigner is not ready to offer finished split information, this should not be called");
            throw new FlinkRuntimeException("The assigner is not ready to offer finished split information, this should not be called");
        }
        ArrayList<SchemalessSnapshotSplit> assignedSnapshotSplit = new ArrayList<SchemalessSnapshotSplit>(this.assignedSplits.values());
        ArrayList<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = new ArrayList<FinishedSnapshotSplitInfo>();
        for (SchemalessSnapshotSplit split : assignedSnapshotSplit) {
            Offset finishedOffset = this.splitFinishedOffsets.get(split.splitId());
            finishedSnapshotSplitInfos.add(new FinishedSnapshotSplitInfo(split.getTableId(), split.splitId(), split.getSplitStart(), split.getSplitEnd(), finishedOffset, this.offsetFactory));
        }
        return finishedSnapshotSplitInfos;
    }

    @Override
    public void onFinishedSplits(Map<String, Offset> splitFinishedOffsets) {
        this.splitFinishedOffsets.putAll(splitFinishedOffsets);
        if (this.allSnapshotSplitsFinished() && AssignerStatus.isAssigningSnapshotSplits(this.assignerStatus)) {
            if (this.currentParallelism == 1) {
                this.assignerStatus = this.assignerStatus.onFinish();
                LOG.info("Snapshot split assigner received all splits finished and the job parallelism is 1, snapshot split assigner is turn into finished status.");
            } else {
                LOG.info("Snapshot split assigner received all splits finished, waiting for a complete checkpoint to mark the assigner finished.");
            }
        }
    }

    @Override
    public void addSplits(Collection<SourceSplitBase> splits) {
        for (SourceSplitBase split : splits) {
            this.tableSchemas.putAll(split.asSnapshotSplit().getTableSchemas());
            this.remainingSplits.add(split.asSnapshotSplit().toSchemalessSnapshotSplit());
            this.assignedSplits.remove(split.splitId());
            this.splitFinishedOffsets.remove(split.splitId());
        }
    }

    @Override
    public SnapshotPendingSplitsState snapshotState(long checkpointId) {
        SnapshotPendingSplitsState state = new SnapshotPendingSplitsState(this.alreadyProcessedTables, this.remainingSplits, this.assignedSplits, this.tableSchemas, this.splitFinishedOffsets, this.assignerStatus, this.remainingTables, this.isTableIdCaseSensitive, true);
        if (this.checkpointIdToFinish == null && AssignerStatus.isAssigningSnapshotSplits(this.assignerStatus) && this.allSnapshotSplitsFinished()) {
            this.checkpointIdToFinish = checkpointId;
        }
        return state;
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
        if (this.checkpointIdToFinish != null && AssignerStatus.isAssigningSnapshotSplits(this.assignerStatus) && this.allSnapshotSplitsFinished()) {
            if (checkpointId >= this.checkpointIdToFinish) {
                this.assignerStatus = this.assignerStatus.onFinish();
            }
            LOG.info("Snapshot split assigner is turn into finished status.");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean noMoreSplits() {
        return this.remainingTables.isEmpty() && this.remainingSplits.isEmpty();
    }

    public boolean needToDiscoveryTables() {
        return this.remainingTables.isEmpty() && this.remainingSplits.isEmpty() && this.alreadyProcessedTables.isEmpty();
    }

    public Map<String, SchemalessSnapshotSplit> getAssignedSplits() {
        return this.assignedSplits;
    }

    @Override
    public AssignerStatus getAssignerStatus() {
        return this.assignerStatus;
    }

    @Override
    public void startAssignNewlyAddedTables() {
        Preconditions.checkState((boolean)AssignerStatus.isAssigningFinished(this.assignerStatus), (String)"Invalid assigner status {}", (Object[])new Object[]{this.assignerStatus});
        this.assignerStatus = this.assignerStatus.startAssignNewlyTables();
    }

    @Override
    public void onStreamSplitUpdated() {
        Preconditions.checkState((boolean)AssignerStatus.isNewlyAddedAssigningSnapshotFinished(this.assignerStatus), (String)"Invalid assigner status {}", (Object[])new Object[]{this.assignerStatus});
        this.assignerStatus = this.assignerStatus.onStreamSplitUpdated();
    }

    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public Map<String, Offset> getSplitFinishedOffsets() {
        return this.splitFinishedOffsets;
    }

    private boolean allSnapshotSplitsFinished() {
        return this.noMoreSplits() && this.assignedSplits.size() == this.splitFinishedOffsets.size();
    }
}

