/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage;

import com.oceanbase.oms.common.enums.DbTypeEnum;
import com.oceanbase.oms.logmessage.ByteString;
import com.oceanbase.oms.logmessage.FieldParseListener;
import com.oceanbase.oms.logmessage.Message;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelper;
import com.oceanbase.oms.logmessage.typehelper.LogTypeHelperFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.commons.lang3.StringUtils;

public class DataMessage
extends Message {
    private final List<Record> records;

    public DataMessage() {
        this.type = 100;
        this.records = new ArrayList<Record>();
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public List<Record> getRecordList() {
        return this.records;
    }

    public void mergeFrom(DataInputStream reader, String regionId) throws IOException {
        while (true) {
            Record record = new Record();
            record.mergeFrom(reader);
            record.setRegionId(regionId);
            if (record.isEnding()) break;
            this.records.add(record);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.records.clear();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        for (Record record : this.records) {
            builder.append(record.toString());
        }
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }

    public void addRecord(Record r) {
        this.records.add(r);
    }

    public static DbTypeEnum parseDbTypeStr(String dbTypeInStr) {
        if (StringUtils.isEmpty(dbTypeInStr)) {
            return DbTypeEnum.UNKNOWN;
        }
        if ("mysql".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.MYSQL;
        }
        if ("oceanbase".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.OB_05;
        }
        if ("oracle".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.ORACLE;
        }
        if ("hbase".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.HBASE;
        }
        if ("oceanbase_1_0".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.OB_MYSQL;
        }
        if ("db2".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.DB2_LUW;
        }
        if ("postgresql".equalsIgnoreCase(dbTypeInStr)) {
            return DbTypeEnum.POSTGRESQL;
        }
        return DbTypeEnum.UNKNOWN;
    }

    public static DbTypeEnum parseDBTypeCode(int dbTypeCode) {
        switch (dbTypeCode) {
            case 0: {
                return DbTypeEnum.MYSQL;
            }
            case 1: {
                return DbTypeEnum.OB_05;
            }
            case 2: {
                return DbTypeEnum.HBASE;
            }
            case 3: {
                return DbTypeEnum.ORACLE;
            }
            case 4: {
                return DbTypeEnum.OB_MYSQL;
            }
            case 5: {
                return DbTypeEnum.DB2_LUW;
            }
            case 6: {
                return DbTypeEnum.POSTGRESQL;
            }
        }
        return DbTypeEnum.UNKNOWN;
    }

    public static class Record {
        public static final String UTF8MB4_ENCODING = "utf8mb4";
        public static final String TRACEID_STRING = "traceid";
        protected Type type;
        protected Map<String, String> attributes = new HashMap<String, String>();
        protected List<Field> fields;
        protected String timestamp;
        protected String safeTimestamp;
        protected static ThreadLocal<String> globalSafeTimestamp = new ThreadLocal();
        protected static ThreadLocal<Boolean> txEnd = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };
        private boolean isConnectionFirstRecord = false;
        private boolean ending = false;
        private String regionId;

        public void setColFilter(List<String> colFilter) {
            throw new UnsupportedOperationException();
        }

        public List<String> getPrimaryKeyValue() {
            throw new UnsupportedOperationException();
        }

        public Set<String> getKeysValue() throws Exception {
            throw new UnsupportedOperationException();
        }

        public List<String> getPrimaryValues() throws Exception {
            throw new UnsupportedOperationException();
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<ByteString> getFirstPKValue() {
            return null;
        }

        public void setIsConnectionFirstRecord(boolean value) {
            this.isConnectionFirstRecord = value;
        }

        public boolean getIsConnectionFirstRecord() {
            return this.isConnectionFirstRecord;
        }

        public Long getLogSeqNum() {
            return 0L;
        }

        boolean isEnding() {
            return this.ending;
        }

        public void mergeFrom(DataInputStream reader) throws IOException {
            block15: {
                String[] encodings;
                LogTypeHelper logTypeHelper;
                block16: {
                    String line;
                    boolean first = true;
                    while (!(line = reader.readLine()).isEmpty()) {
                        String[] kv = StringUtils.split(line, ':');
                        if (2 != kv.length) {
                            if (kv.length <= 2 || !StringUtils.equals(kv[0], TRACEID_STRING)) continue;
                            kv[1] = line.substring(line.indexOf(58) + 1);
                        }
                        this.addAttribute(kv[0], kv[1]);
                        first = false;
                    }
                    if (first) {
                        this.ending = true;
                        return;
                    }
                    String textPKs = this.getPrimaryKeys();
                    List<Object> pkList = Collections.emptyList();
                    if (textPKs != null && !textPKs.isEmpty()) {
                        pkList = Arrays.asList(textPKs.split(","));
                    }
                    String stype = this.getAttribute("record_type");
                    this.type = Type.valueOf(stype.toUpperCase());
                    this.timestamp = this.getAttribute("timestamp");
                    DbTypeEnum dbType = this.getDbType();
                    logTypeHelper = LogTypeHelperFactory.getInstance(dbType);
                    if (dbType == DbTypeEnum.OB_MYSQL || dbType == DbTypeEnum.OB_ORACLE) {
                        if (this.type == Type.HEARTBEAT) {
                            globalSafeTimestamp.set(this.timestamp);
                        } else {
                            globalSafeTimestamp.set(this.getCheckpoint().substring(2));
                        }
                    } else {
                        if (this.type == Type.BEGIN) {
                            globalSafeTimestamp.set(this.timestamp);
                            txEnd.set(false);
                        }
                        if (txEnd.get().booleanValue()) {
                            globalSafeTimestamp.set(this.timestamp);
                        }
                        if (this.type == Type.COMMIT || this.type == Type.ROLLBACK) {
                            txEnd.set(true);
                        }
                    }
                    this.safeTimestamp = new String(globalSafeTimestamp.get());
                    this.fields = new ArrayList<Field>();
                    while (true) {
                        Field field = new Field();
                        field.mergeFrom(reader, this.getAttribute("record_encoding"));
                        if (field.name == null) break;
                        if (textPKs != null && !textPKs.isEmpty() && pkList.contains(field.name)) {
                            field.primaryKey = true;
                        }
                        this.fields.add(field);
                    }
                    String fieldsEncodings = this.getAttribute("fields_enc");
                    if (fieldsEncodings == null || fieldsEncodings.isEmpty()) break block15;
                    encodings = fieldsEncodings.split(",", -1);
                    if (encodings.length != this.fields.size()) break block16;
                    for (int i = 0; i < encodings.length; ++i) {
                        String enc = encodings[i];
                        Field field = this.fields.get(i);
                        logTypeHelper.correctField(field, enc);
                    }
                    break block15;
                }
                if (encodings.length * 2 != this.fields.size()) break block15;
                for (int i = 0; i < encodings.length; ++i) {
                    String enc = encodings[i];
                    Field field1 = this.fields.get(i * 2);
                    Field field2 = this.fields.get(i * 2 + 1);
                    logTypeHelper.correctField(field1, enc);
                    logTypeHelper.correctField(field2, enc);
                }
            }
        }

        public Type getOpt() {
            return this.type;
        }

        public String getId() {
            return this.getAttribute("record_id");
        }

        public String getDbName() {
            return this.getAttribute("db");
        }

        public String getTableName() {
            return this.getAttribute("table_name");
        }

        public String getCheckpoint() {
            return this.getAttribute("checkpoint");
        }

        @Deprecated
        public String getMetadataVersion() {
            return this.getAttribute("meta");
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getTimestampUsec() throws IOException {
            return null;
        }

        public String getSafeTimestamp() {
            return this.safeTimestamp;
        }

        public String getServerId() {
            return this.getAttribute("instance");
        }

        public String getPrevId() {
            return this.getAttribute("prev_id");
        }

        public String getServerSeq() {
            return this.getAttribute("server_id");
        }

        public String getPrevServerSeq() {
            return this.getAttribute("prev_server_id");
        }

        public List<int[]> getPrimaryAndUniqueConstraintColumnIndexTuples() {
            return null;
        }

        public String getPrimaryKeys() {
            return this.getAttribute("primary");
        }

        public boolean isKeyChange() {
            return false;
        }

        public List<String> getPrimaryKeysList() {
            ArrayList<String> pks = new ArrayList<String>();
            return pks;
        }

        public String getTraceInfo() {
            return "";
        }

        public String getOB10UniqueId() throws Exception {
            return null;
        }

        public String getUniqueColNames() {
            return this.getAttribute("unique");
        }

        public DbTypeEnum getDbType() {
            return DataMessage.parseDbTypeStr(this.getAttribute("source_type"));
        }

        public boolean isQueryBack() {
            String cate = this.getAttribute("source_category");
            return !"full_recorded".equalsIgnoreCase(cate) && !"part_recorded".equalsIgnoreCase(cate) && !"full_faked".equalsIgnoreCase(cate);
        }

        public boolean isFirstInLogEvent() {
            String isFirstLogEvent = this.getAttribute("logevent");
            return "1".equals(isFirstLogEvent);
        }

        public String getAttribute(String key) {
            return this.attributes.get(key);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public int getFieldCount() {
            this.getFieldList();
            if (this.fields == null) {
                return 0;
            }
            return this.fields.size();
        }

        public List<Field> getFieldList() {
            return this.fields;
        }

        public void fieldListParse(FieldParseListener fieldParseListener) throws Exception {
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public byte[] getRawData() {
            return null;
        }

        public String getThreadId() throws Exception {
            return this.getAttribute("threadid");
        }

        public String getTraceId() throws Exception {
            return this.getAttribute(TRACEID_STRING);
        }

        public void parse(byte[] data) throws Exception {
            throw new IOException(Record.class.getName() + " not support parse from raw data");
        }

        public long getMessageUniqueId() throws Exception {
            return Record.hash64(this.getMessageUniqueIdStr());
        }

        public String getMessageUniqueIdStr() throws Exception {
            DbTypeEnum dbType = this.getDbType();
            this.checkDBType(dbType);
            StringBuilder messageId = new StringBuilder();
            if (dbType == DbTypeEnum.MYSQL) {
                messageId.append(this.getServerId());
            }
            messageId.append("/").append(this.getCommonPart()).append("/");
            if (dbType == DbTypeEnum.OB_MYSQL || dbType == DbTypeEnum.OB_ORACLE) {
                messageId.append("/");
            } else {
                String checkpoint = this.getCheckpoint();
                messageId.append(checkpoint.substring(checkpoint.indexOf(64) + 1)).append("/").append(checkpoint, 0, checkpoint.indexOf(64));
            }
            messageId.append("/");
            if (dbType == DbTypeEnum.OB_MYSQL || dbType == DbTypeEnum.OB_ORACLE) {
                messageId.append(this.getOB10UniqueId());
            }
            messageId.append("/").append(this.getTimestamp());
            return messageId.toString();
        }

        private void checkDBType(DbTypeEnum dbType) {
            switch (dbType) {
                case MYSQL: 
                case ORACLE: 
                case DB2_LUW: 
                case OB_MYSQL: 
                case OB_ORACLE: 
                case OB_05: {
                    break;
                }
                default: {
                    throw new IllegalStateException("dbType [" + (Object)((Object)dbType) + "] is not valid for messageId");
                }
            }
        }

        private String getCommonPart() {
            String dbType = this.getDbType().toString();
            String opType = this.getOpt().toString();
            String dbName = this.getDbName();
            String tableName = this.getTableName();
            return dbType + "/" + opType + "/" + dbName + "/" + tableName;
        }

        private static long hash64(String string) {
            long h = 1125899906842597L;
            int len = string.length();
            for (int i = 0; i < len; ++i) {
                h = 31L * h + (long)string.charAt(i);
            }
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                builder.append(entry.getKey() + ":" + entry.getValue());
                builder.append(System.getProperty("line.separator"));
            }
            builder.append(System.getProperty("line.separator"));
            if (null != this.fields) {
                for (Field field : this.fields) {
                    builder.append(field.toString());
                }
            }
            builder.append(System.getProperty("line.separator"));
            return builder.toString();
        }

        public static enum Type {
            INSERT(0),
            UPDATE(1),
            DELETE(2),
            REPLACE(3),
            HEARTBEAT(4),
            CONSISTENCY_TEST(5),
            BEGIN(6),
            COMMIT(7),
            DDL(8),
            ROLLBACK(9),
            DML(10),
            UNKNOWN(11),
            INDEX_INSERT(128),
            INDEX_UPDATE(129),
            INDEX_DELETE(130),
            INDEX_REPLACE(131);

            final int _value;

            private Type(int value) {
                this._value = value;
            }

            public int value() {
                return this._value;
            }

            public static Type valueOf(int value) {
                for (Type type : Type.values()) {
                    if (type.value() != value) continue;
                    return type;
                }
                return UNKNOWN;
            }
        }

        public static class Field {
            public long length;
            public boolean primaryKey;
            public String name;
            public int type;
            public int flag;
            public String encoding;
            public ByteString value;
            public boolean changeValue = true;
            public boolean prev = false;
            public boolean notNull = false;
            public static Type[] MYSQL_TYPES = new Type[256];

            public Field() {
                this.name = null;
                this.type = 17;
                this.flag = 0;
                this.length = 0L;
                this.value = null;
                this.primaryKey = false;
            }

            public Field(String name, int type, String encoding, ByteString value, boolean pk) {
                this.name = name;
                this.type = type;
                this.encoding = encoding;
                if (this.getType() == Type.STRING && this.encoding.isEmpty()) {
                    this.encoding = "binary";
                }
                this.value = value;
                this.length = value == null ? -1L : (long)value.getLen();
                this.primaryKey = pk;
            }

            public final boolean isGenerated() {
                return ((long)this.flag & 1L) == 1L;
            }

            public void setFlag(int flag) {
                this.flag = flag;
            }

            public void setNotNull(boolean notNull) {
                this.notNull = notNull;
            }

            public final boolean isPrimary() {
                return this.primaryKey;
            }

            public final int getRawType() {
                return this.type;
            }

            public void setPrimary(boolean primary) {
                this.primaryKey = primary;
            }

            public final String getFieldname() {
                return this.name;
            }

            public final String getEncoding() {
                if (Record.UTF8MB4_ENCODING.equalsIgnoreCase(this.encoding)) {
                    return "utf8";
                }
                return this.encoding;
            }

            public final boolean getNotNull() {
                return this.notNull;
            }

            public boolean isOracleLobType() {
                return this.type >= 249 && this.type <= 253;
            }

            public final Type getType() {
                if (this.type > 16 && this.type < 197 || this.type > 211 && this.type < 245) {
                    return Type.UNKOWN;
                }
                return MYSQL_TYPES[this.type];
            }

            public boolean isChangeValue() {
                return this.changeValue;
            }

            public boolean isPrev() {
                return this.prev;
            }

            public void setPrev(boolean prev) {
                this.prev = prev;
            }

            public final ByteString getValue() {
                return this.value;
            }

            public void setValue(ByteString v) {
                this.value = v;
            }

            public void mergeFrom(DataInputStream reader, String recordEncoding) throws IOException {
                this.name = reader.readLine();
                if (this.name.isEmpty()) {
                    this.clear();
                    return;
                }
                this.type = Integer.parseInt(reader.readLine());
                this.length = Long.parseLong(reader.readLine());
                this.encoding = recordEncoding;
                if (this.length != -1L) {
                    byte[] valueBytes = new byte[(int)this.length];
                    reader.readFully(valueBytes);
                    this.value = new ByteString(valueBytes, (int)this.length);
                } else {
                    this.value = null;
                }
                if (reader.readByte() == 13) {
                    reader.readByte();
                }
            }

            public void clear() {
                this.type = 17;
                this.name = null;
                this.length = 0L;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("Field name: " + this.name + System.getProperty("line.separator"));
                builder.append("Field type: " + this.type + System.getProperty("line.separator"));
                builder.append("Field length: " + this.length + System.getProperty("line.separator"));
                builder.append("Field notNull: " + this.notNull + System.getProperty("line.separator"));
                if (this.value != null) {
                    if ("binary".equalsIgnoreCase(this.encoding)) {
                        builder.append("Field value(binary): " + Arrays.toString(this.value.getBytes()) + System.getProperty("line.separator"));
                    } else {
                        builder.append("Field value: " + this.value.toString(this.encoding) + System.getProperty("line.separator"));
                    }
                } else {
                    builder.append("Field value: null" + System.getProperty("line.separator"));
                }
                return builder.toString();
            }

            static {
                Field.MYSQL_TYPES[0] = Type.DECIMAL;
                Field.MYSQL_TYPES[1] = Type.INT8;
                Field.MYSQL_TYPES[2] = Type.INT16;
                Field.MYSQL_TYPES[3] = Type.INT32;
                Field.MYSQL_TYPES[4] = Type.FLOAT;
                Field.MYSQL_TYPES[5] = Type.DOUBLE;
                Field.MYSQL_TYPES[6] = Type.NULL;
                Field.MYSQL_TYPES[7] = Type.TIMESTAMP;
                Field.MYSQL_TYPES[8] = Type.INT64;
                Field.MYSQL_TYPES[9] = Type.INT24;
                Field.MYSQL_TYPES[10] = Type.DATE;
                Field.MYSQL_TYPES[11] = Type.TIME;
                Field.MYSQL_TYPES[12] = Type.DATETIME;
                Field.MYSQL_TYPES[13] = Type.YEAR;
                Field.MYSQL_TYPES[14] = Type.DATETIME;
                Field.MYSQL_TYPES[15] = Type.STRING;
                Field.MYSQL_TYPES[16] = Type.BIT;
                Field.MYSQL_TYPES[197] = Type.CLOB;
                Field.MYSQL_TYPES[198] = Type.BINARY;
                Field.MYSQL_TYPES[199] = Type.BINARY;
                Field.MYSQL_TYPES[200] = Type.TIMESTAMP_WITH_TIME_ZONE;
                Field.MYSQL_TYPES[201] = Type.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
                Field.MYSQL_TYPES[202] = Type.TIMESTAMP_NANO;
                Field.MYSQL_TYPES[203] = Type.RAW;
                Field.MYSQL_TYPES[204] = Type.INTERVAL_YEAR_TO_MONTH;
                Field.MYSQL_TYPES[205] = Type.INTERVAL_DAY_TO_SECOND;
                Field.MYSQL_TYPES[206] = Type.FLOAT;
                Field.MYSQL_TYPES[207] = Type.STRING;
                Field.MYSQL_TYPES[208] = Type.STRING;
                Field.MYSQL_TYPES[209] = Type.STRING;
                Field.MYSQL_TYPES[210] = Type.BLOB;
                Field.MYSQL_TYPES[211] = Type.CLOB;
                Field.MYSQL_TYPES[255] = Type.GEOMETRY;
                Field.MYSQL_TYPES[254] = Type.STRING;
                Field.MYSQL_TYPES[253] = Type.STRING;
                Field.MYSQL_TYPES[252] = Type.BLOB;
                Field.MYSQL_TYPES[251] = Type.BLOB;
                Field.MYSQL_TYPES[250] = Type.BLOB;
                Field.MYSQL_TYPES[249] = Type.BLOB;
                Field.MYSQL_TYPES[248] = Type.SET;
                Field.MYSQL_TYPES[247] = Type.ENUM;
                Field.MYSQL_TYPES[246] = Type.DECIMAL;
                Field.MYSQL_TYPES[245] = Type.JSON;
            }

            public static enum Type {
                INT8,
                INT16,
                INT24,
                INT32,
                INT64,
                DECIMAL,
                FLOAT,
                DOUBLE,
                NULL,
                TIMESTAMP,
                DATE,
                TIME,
                DATETIME,
                YEAR,
                BIT,
                ENUM,
                SET,
                BLOB,
                GEOMETRY,
                STRING,
                JSON,
                BINARY,
                TIMESTAMP_WITH_TIME_ZONE,
                TIMESTAMP_WITH_LOCAL_TIME_ZONE,
                TIMESTAMP_NANO,
                RAW,
                INTERVAL_YEAR_TO_MONTH,
                INTERVAL_DAY_TO_SECOND,
                CLOB,
                UNKOWN;

            }
        }
    }
}

