/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.errors.ApiException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;

public class RemoveMembersFromConsumerGroupResult {
    private final KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future;
    private final Set<MemberToRemove> memberInfos;

    RemoveMembersFromConsumerGroupResult(KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future, Set<MemberToRemove> memberInfos) {
        this.future = future;
        this.memberInfos = memberInfos;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                if (this.removeAll()) {
                    for (Map.Entry entry : memberErrors.entrySet()) {
                        ApiException exception = ((Errors)((Object)((Object)entry.getValue()))).exception();
                        if (exception == null) continue;
                        KafkaException ex = new KafkaException("Encounter exception when trying to remove: " + entry.getKey(), exception);
                        result.completeExceptionally(ex);
                        return;
                    }
                } else {
                    for (MemberToRemove memberToRemove : this.memberInfos) {
                        if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, memberToRemove.toMemberIdentity(), result)) continue;
                        return;
                    }
                }
                result.complete(null);
            }
        });
        return result;
    }

    public KafkaFuture<Void> memberResult(MemberToRemove member) {
        if (this.removeAll()) {
            throw new IllegalArgumentException("The method: memberResult is not applicable in 'removeAll' mode");
        }
        if (!this.memberInfos.contains(member)) {
            throw new IllegalArgumentException("Member " + member + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, member.toMemberIdentity(), result)) {
                result.complete(null);
            }
        });
        return result;
    }

    private boolean maybeCompleteExceptionally(Map<LeaveGroupRequestData.MemberIdentity, Errors> memberErrors, LeaveGroupRequestData.MemberIdentity member, KafkaFutureImpl<Void> result) {
        Throwable exception = KafkaAdminClient.getSubLevelError(memberErrors, member, "Member \"" + member + "\" was not included in the removal response");
        if (exception != null) {
            result.completeExceptionally(exception);
            return true;
        }
        return false;
    }

    private boolean removeAll() {
        return this.memberInfos.isEmpty();
    }
}

