/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.util;

import java.util.ArrayList;
import java.util.List;

public class ConnectorUtils {
    public static <T> List<List<T>> groupPartitions(List<T> elements, int numGroups) {
        if (numGroups <= 0) {
            throw new IllegalArgumentException("Number of groups must be positive.");
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>(numGroups);
        int perGroup = elements.size() / numGroups;
        int leftover = elements.size() - numGroups * perGroup;
        int assigned = 0;
        for (int group = 0; group < numGroups; ++group) {
            int numThisGroup = group < leftover ? perGroup + 1 : perGroup;
            ArrayList<T> groupList = new ArrayList<T>(numThisGroup);
            for (int i = 0; i < numThisGroup; ++i) {
                groupList.add(elements.get(assigned));
                ++assigned;
            }
            result.add(groupList);
        }
        return result;
    }
}

