/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.TransactionDescription;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeTransactionsResult {
    private final Map<CoordinatorKey, KafkaFuture<TransactionDescription>> futures;

    DescribeTransactionsResult(Map<CoordinatorKey, KafkaFuture<TransactionDescription>> futures) {
        this.futures = futures;
    }

    public KafkaFuture<TransactionDescription> description(String transactionalId) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId(transactionalId);
        KafkaFuture<TransactionDescription> future = this.futures.get(key);
        if (future == null) {
            throw new IllegalArgumentException("TransactionalId `" + transactionalId + "` was not included in the request");
        }
        return future;
    }

    public KafkaFuture<Map<String, TransactionDescription>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap<String, TransactionDescription> results = new HashMap<String, TransactionDescription>(this.futures.size());
            for (Map.Entry<CoordinatorKey, KafkaFuture<TransactionDescription>> entry : this.futures.entrySet()) {
                try {
                    results.put(entry.getKey().idValue, entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return results;
        });
    }
}

