/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.offset;

import io.debezium.connector.mysql.MySqlConnection;
import org.apache.flink.cdc.connectors.mysql.debezium.DebeziumUtils;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffsetKind;

public class BinlogOffsetUtils {
    public static BinlogOffset initializeEffectiveOffset(BinlogOffset offset, MySqlConnection connection, MySqlSourceConfig mySqlSourceConfig) {
        BinlogOffsetKind offsetKind = offset.getOffsetKind();
        switch (offsetKind) {
            case EARLIEST: {
                return BinlogOffset.ofBinlogFilePosition("", 0L);
            }
            case TIMESTAMP: {
                return DebeziumUtils.findBinlogOffset(offset.getTimestampSec() * 1000L, connection, mySqlSourceConfig);
            }
            case LATEST: {
                return DebeziumUtils.currentBinlogOffset(connection);
            }
        }
        return offset;
    }

    public static boolean isNonStoppingOffset(BinlogOffset binlogOffset) {
        return BinlogOffsetKind.NON_STOPPING.equals((Object)binlogOffset.getOffsetKind());
    }
}

