/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.offset;

import io.debezium.connector.mysql.GtidSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffsetBuilder;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffsetKind;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;

@PublicEvolving
public class BinlogOffset
implements Comparable<BinlogOffset>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String ROWS_TO_SKIP_OFFSET_KEY = "row";
    public static final String GTID_SET_KEY = "gtids";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String SERVER_ID_KEY = "server_id";
    public static final String OFFSET_KIND_KEY = "kind";
    private final Map<String, String> offset;

    public static BinlogOffsetBuilder builder() {
        return new BinlogOffsetBuilder();
    }

    public static BinlogOffset ofBinlogFilePosition(String filename, long position) {
        return BinlogOffset.builder().setBinlogFilePosition(filename, position).build();
    }

    public static BinlogOffset ofGtidSet(String gtidSet) {
        return BinlogOffset.builder().setBinlogFilePosition("", 0L).setGtidSet(gtidSet).build();
    }

    public static BinlogOffset ofEarliest() {
        return BinlogOffset.builder().setOffsetKind(BinlogOffsetKind.EARLIEST).build();
    }

    public static BinlogOffset ofLatest() {
        return BinlogOffset.builder().setOffsetKind(BinlogOffsetKind.LATEST).build();
    }

    public static BinlogOffset ofTimestampSec(long timestampSec) {
        return BinlogOffset.builder().setOffsetKind(BinlogOffsetKind.TIMESTAMP).setTimestampSec(timestampSec).build();
    }

    @Internal
    public static BinlogOffset ofNonStopping() {
        return BinlogOffset.builder().setOffsetKind(BinlogOffsetKind.NON_STOPPING).build();
    }

    @VisibleForTesting
    public BinlogOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public Map<String, String> getOffset() {
        return this.offset;
    }

    public String getFilename() {
        return this.offset.get(BINLOG_FILENAME_OFFSET_KEY);
    }

    public long getPosition() {
        return this.longOffsetValue(this.offset, BINLOG_POSITION_OFFSET_KEY);
    }

    public long getRestartSkipEvents() {
        return this.longOffsetValue(this.offset, EVENTS_TO_SKIP_OFFSET_KEY);
    }

    public long getRestartSkipRows() {
        return this.longOffsetValue(this.offset, ROWS_TO_SKIP_OFFSET_KEY);
    }

    public String getGtidSet() {
        return this.offset.get(GTID_SET_KEY);
    }

    public long getTimestampSec() {
        return this.longOffsetValue(this.offset, TIMESTAMP_KEY);
    }

    public Long getServerId() {
        return this.longOffsetValue(this.offset, SERVER_ID_KEY);
    }

    @Nullable
    public BinlogOffsetKind getOffsetKind() {
        if (this.offset.get(OFFSET_KIND_KEY) == null) {
            return null;
        }
        return BinlogOffsetKind.valueOf(this.offset.get(OFFSET_KIND_KEY));
    }

    private long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    @Override
    public int compareTo(BinlogOffset that) {
        long targetServerId;
        if (that.getOffsetKind() == BinlogOffsetKind.NON_STOPPING && this.getOffsetKind() == BinlogOffsetKind.NON_STOPPING) {
            return 0;
        }
        if (this.getOffsetKind() == BinlogOffsetKind.NON_STOPPING) {
            return 1;
        }
        if (that.getOffsetKind() == BinlogOffsetKind.NON_STOPPING) {
            return -1;
        }
        String gtidSetStr = this.getGtidSet();
        String targetGtidSetStr = that.getGtidSet();
        if (StringUtils.isNotEmpty((CharSequence)targetGtidSetStr)) {
            if (StringUtils.isNotEmpty((CharSequence)gtidSetStr)) {
                GtidSet gtidSet = new GtidSet(gtidSetStr);
                GtidSet targetGtidSet = new GtidSet(targetGtidSetStr);
                if (gtidSet.equals(targetGtidSet)) {
                    long restartSkipEvents = this.getRestartSkipEvents();
                    long targetRestartSkipEvents = that.getRestartSkipEvents();
                    return Long.compare(restartSkipEvents, targetRestartSkipEvents);
                }
                return gtidSet.isContainedWithin(targetGtidSet) ? -1 : 1;
            }
            return -1;
        }
        if (StringUtils.isNotEmpty((CharSequence)gtidSetStr)) {
            return 1;
        }
        long serverId = this.getServerId();
        if (serverId != (targetServerId = that.getServerId().longValue())) {
            long timestamp = this.getTimestampSec();
            long targetTimestamp = that.getTimestampSec();
            if (timestamp != 0L && targetTimestamp != 0L) {
                return Long.compare(timestamp, targetTimestamp);
            }
        }
        if (this.getFilename().compareToIgnoreCase(that.getFilename()) != 0) {
            return this.getFilename().compareToIgnoreCase(that.getFilename());
        }
        if (this.getPosition() != that.getPosition()) {
            return Long.compare(this.getPosition(), that.getPosition());
        }
        if (this.getRestartSkipEvents() != that.getRestartSkipEvents()) {
            return Long.compare(this.getRestartSkipEvents(), that.getRestartSkipEvents());
        }
        return Long.compare(this.getRestartSkipRows(), that.getRestartSkipRows());
    }

    public boolean isAtOrBefore(BinlogOffset that) {
        return this.compareTo(that) <= 0;
    }

    public boolean isBefore(BinlogOffset that) {
        return this.compareTo(that) < 0;
    }

    public boolean isAtOrAfter(BinlogOffset that) {
        return this.compareTo(that) >= 0;
    }

    public boolean isAfter(BinlogOffset that) {
        return this.compareTo(that) > 0;
    }

    public String toString() {
        return this.offset.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinlogOffset)) {
            return false;
        }
        BinlogOffset that = (BinlogOffset)o;
        return this.offset.equals(that.offset);
    }

    public int hashCode() {
        return Objects.hashCode(this.offset);
    }
}

