/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.schema;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;

@PublicEvolving
public class MetadataColumn
extends Column {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String metadataKey;

    public MetadataColumn(String name, DataType type, @Nullable String metadataKey, @Nullable String comment) {
        super(name, type, comment);
        this.metadataKey = metadataKey;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Nullable
    public String getMetadataKey() {
        return this.metadataKey;
    }

    @Override
    public Column copy(DataType newType) {
        return new MetadataColumn(this.name, newType, this.metadataKey, this.comment);
    }

    @Override
    public Column copy(String newName) {
        return new MetadataColumn(newName, this.type, this.metadataKey, this.comment);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataColumn)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataColumn that = (MetadataColumn)o;
        return Objects.equals(this.metadataKey, that.metadataKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.metadataKey);
    }
}

