/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;

@InterfaceStability.Evolving
public final class ElectLeadersResult {
    private final KafkaFuture<Map<TopicPartition, Optional<Throwable>>> electionFuture;

    ElectLeadersResult(KafkaFuture<Map<TopicPartition, Optional<Throwable>>> electionFuture) {
        this.electionFuture = electionFuture;
    }

    public KafkaFuture<Map<TopicPartition, Optional<Throwable>>> partitions() {
        return this.electionFuture;
    }

    public KafkaFuture<Void> all() {
        final KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.partitions().whenComplete(new KafkaFuture.BiConsumer<Map<TopicPartition, Optional<Throwable>>, Throwable>(){

            @Override
            public void accept(Map<TopicPartition, Optional<Throwable>> topicPartitions, Throwable throwable) {
                if (throwable != null) {
                    result.completeExceptionally(throwable);
                } else {
                    for (Optional<Throwable> exception : topicPartitions.values()) {
                        if (!exception.isPresent()) continue;
                        result.completeExceptionally(exception.get());
                        return;
                    }
                    result.complete(null);
                }
            }
        });
        return result;
    }
}

