/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.config;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.mysql.schema.Selectors;
import org.apache.flink.cdc.connectors.mysql.source.config.ServerIdRange;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.util.Preconditions;

public class MySqlSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;
    private final List<String> databaseList;
    private final List<String> tableList;
    private final String excludeTableList;
    @Nullable
    private final ServerIdRange serverIdRange;
    private final StartupOptions startupOptions;
    private final int splitSize;
    private final int splitMetaGroupSize;
    private final int fetchSize;
    private final String serverTimeZone;
    private final Duration connectTimeout;
    private final int connectMaxRetries;
    private final int connectionPoolSize;
    private final double distributionFactorUpper;
    private final double distributionFactorLower;
    private final boolean includeSchemaChanges;
    private final boolean scanNewlyAddedTableEnabled;
    private final boolean closeIdleReaders;
    private final Properties jdbcProperties;
    private final Map<ObjectPath, String> chunkKeyColumns;
    private final boolean skipSnapshotBackfill;
    private final boolean parseOnLineSchemaChanges;
    public static boolean useLegacyJsonFormat = true;
    private final Properties dbzProperties;
    private final Configuration dbzConfiguration;
    private final MySqlConnectorConfig dbzMySqlConfig;
    private final boolean treatTinyInt1AsBoolean;

    MySqlSourceConfig(String hostname, int port, String username, String password, List<String> databaseList, List<String> tableList, @Nullable String excludeTableList, @Nullable ServerIdRange serverIdRange, StartupOptions startupOptions, int splitSize, int splitMetaGroupSize, int fetchSize, String serverTimeZone, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, double distributionFactorUpper, double distributionFactorLower, boolean includeSchemaChanges, boolean scanNewlyAddedTableEnabled, boolean closeIdleReaders, Properties dbzProperties, Properties jdbcProperties, Map<ObjectPath, String> chunkKeyColumns, boolean skipSnapshotBackfill, boolean parseOnLineSchemaChanges, boolean treatTinyInt1AsBoolean, boolean useLegacyJsonFormat) {
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.port = port;
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = password;
        this.databaseList = (List)Preconditions.checkNotNull(databaseList);
        this.tableList = (List)Preconditions.checkNotNull(tableList);
        this.excludeTableList = excludeTableList;
        this.serverIdRange = serverIdRange;
        this.startupOptions = (StartupOptions)Preconditions.checkNotNull((Object)startupOptions);
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.fetchSize = fetchSize;
        this.serverTimeZone = (String)Preconditions.checkNotNull((Object)serverTimeZone);
        this.connectTimeout = (Duration)Preconditions.checkNotNull((Object)connectTimeout);
        this.connectMaxRetries = connectMaxRetries;
        this.connectionPoolSize = connectionPoolSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.includeSchemaChanges = includeSchemaChanges;
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        this.closeIdleReaders = closeIdleReaders;
        this.dbzProperties = (Properties)Preconditions.checkNotNull((Object)dbzProperties);
        this.dbzConfiguration = Configuration.from(dbzProperties);
        this.dbzMySqlConfig = new MySqlConnectorConfig(this.dbzConfiguration);
        this.jdbcProperties = jdbcProperties;
        this.chunkKeyColumns = chunkKeyColumns;
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        this.parseOnLineSchemaChanges = parseOnLineSchemaChanges;
        this.treatTinyInt1AsBoolean = treatTinyInt1AsBoolean;
        MySqlSourceConfig.useLegacyJsonFormat = useLegacyJsonFormat;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getDatabaseList() {
        return this.databaseList;
    }

    public List<String> getTableList() {
        return this.tableList;
    }

    @Nullable
    public ServerIdRange getServerIdRange() {
        return this.serverIdRange;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public int getSplitSize() {
        return this.splitSize;
    }

    public int getSplitMetaGroupSize() {
        return this.splitMetaGroupSize;
    }

    public double getDistributionFactorUpper() {
        return this.distributionFactorUpper;
    }

    public double getDistributionFactorLower() {
        return this.distributionFactorLower;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectMaxRetries() {
        return this.connectMaxRetries;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public boolean isScanNewlyAddedTableEnabled() {
        return this.scanNewlyAddedTableEnabled;
    }

    public boolean isCloseIdleReaders() {
        return this.closeIdleReaders;
    }

    public boolean isParseOnLineSchemaChanges() {
        return this.parseOnLineSchemaChanges;
    }

    public Properties getDbzProperties() {
        return this.dbzProperties;
    }

    public Configuration getDbzConfiguration() {
        return this.dbzConfiguration;
    }

    public MySqlConnectorConfig getMySqlConnectorConfig() {
        return this.dbzMySqlConfig;
    }

    @Deprecated
    public RelationalTableFilters getTableFilters() {
        return this.dbzMySqlConfig.getTableFilters();
    }

    public Predicate<String> getDatabaseFilter() {
        RelationalTableFilters tableFilters = this.dbzMySqlConfig.getTableFilters();
        return databaseName -> tableFilters.databaseFilter().test((String)databaseName);
    }

    public Predicate<TableId> getTableFilter() {
        RelationalTableFilters tableFilters = this.dbzMySqlConfig.getTableFilters();
        Selectors excludeTableFilter = this.excludeTableList == null ? null : new Selectors.SelectorsBuilder().includeTables(this.excludeTableList).build();
        return tableId -> tableFilters.dataCollectionFilter().isIncluded((TableId)tableId) && (excludeTableFilter == null || !excludeTableFilter.isMatch((TableId)tableId));
    }

    public Properties getJdbcProperties() {
        return this.jdbcProperties;
    }

    public Map<ObjectPath, String> getChunkKeyColumns() {
        return this.chunkKeyColumns;
    }

    public boolean isSkipSnapshotBackfill() {
        return this.skipSnapshotBackfill;
    }

    public boolean isTreatTinyInt1AsBoolean() {
        return this.treatTinyInt1AsBoolean;
    }
}

