/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import java.time.Duration;
import java.util.Properties;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSource;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MySqlSourceBuilder<T> {
    private final MySqlSourceConfigFactory configFactory = new MySqlSourceConfigFactory();
    private DebeziumDeserializationSchema<T> deserializer;

    public MySqlSourceBuilder<T> hostname(String hostname) {
        this.configFactory.hostname(hostname);
        return this;
    }

    public MySqlSourceBuilder<T> port(int port) {
        this.configFactory.port(port);
        return this;
    }

    public MySqlSourceBuilder<T> databaseList(String ... databaseList) {
        this.configFactory.databaseList(databaseList);
        return this;
    }

    public MySqlSourceBuilder<T> tableList(String ... tableList) {
        this.configFactory.tableList(tableList);
        return this;
    }

    public MySqlSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public MySqlSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public MySqlSourceBuilder<T> serverId(String serverId) {
        this.configFactory.serverId(serverId);
        return this;
    }

    public MySqlSourceBuilder<T> serverTimeZone(String timeZone) {
        this.configFactory.serverTimeZone(timeZone);
        return this;
    }

    public MySqlSourceBuilder<T> chunkKeyColumn(ObjectPath objectPath, String chunkKeyColumn) {
        this.configFactory.chunkKeyColumn(objectPath, chunkKeyColumn);
        return this;
    }

    public MySqlSourceBuilder<T> splitSize(int splitSize) {
        this.configFactory.splitSize(splitSize);
        return this;
    }

    public MySqlSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public MySqlSourceBuilder<T> distributionFactorUpper(double distributionFactorUpper) {
        this.configFactory.distributionFactorUpper(distributionFactorUpper);
        return this;
    }

    public MySqlSourceBuilder<T> distributionFactorLower(double distributionFactorLower) {
        this.configFactory.distributionFactorLower(distributionFactorLower);
        return this;
    }

    public MySqlSourceBuilder<T> fetchSize(int fetchSize) {
        this.configFactory.fetchSize(fetchSize);
        return this;
    }

    public MySqlSourceBuilder<T> connectTimeout(Duration connectTimeout) {
        this.configFactory.connectTimeout(connectTimeout);
        return this;
    }

    public MySqlSourceBuilder<T> connectMaxRetries(int connectMaxRetries) {
        this.configFactory.connectMaxRetries(connectMaxRetries);
        return this;
    }

    public MySqlSourceBuilder<T> connectionPoolSize(int connectionPoolSize) {
        this.configFactory.connectionPoolSize(connectionPoolSize);
        return this;
    }

    public MySqlSourceBuilder<T> includeSchemaChanges(boolean includeSchemaChanges) {
        this.configFactory.includeSchemaChanges(includeSchemaChanges);
        return this;
    }

    public MySqlSourceBuilder<T> scanNewlyAddedTableEnabled(boolean scanNewlyAddedTableEnabled) {
        this.configFactory.scanNewlyAddedTableEnabled(scanNewlyAddedTableEnabled);
        return this;
    }

    public MySqlSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public MySqlSourceBuilder<T> jdbcProperties(Properties jdbcProperties) {
        this.configFactory.jdbcProperties(jdbcProperties);
        return this;
    }

    public MySqlSourceBuilder<T> debeziumProperties(Properties properties) {
        this.configFactory.debeziumProperties(properties);
        return this;
    }

    public MySqlSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public MySqlSourceBuilder<T> heartbeatInterval(Duration heartbeatInterval) {
        this.configFactory.heartbeatInterval(heartbeatInterval);
        return this;
    }

    public MySqlSourceBuilder<T> skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.configFactory.skipSnapshotBackfill(skipSnapshotBackfill);
        return this;
    }

    public MySqlSourceBuilder<T> useLegacyJsonFormat(boolean useLegacyJsonFormat) {
        this.configFactory.useLegacyJsonFormat(useLegacyJsonFormat);
        return this;
    }

    public MySqlSourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public MySqlSourceBuilder<T> parseOnLineSchemaChanges(boolean parseOnLineSchemaChanges) {
        this.configFactory.parseOnLineSchemaChanges(parseOnLineSchemaChanges);
        return this;
    }

    public MySqlSource<T> build() {
        return new MySqlSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer));
    }
}

