/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.schema;

import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.flink.cdc.common.utils.Predicates;

public class Selectors {
    private List<Selector> selectors;

    private Selectors() {
    }

    public boolean isMatch(TableId tableId) {
        for (Selector selector : this.selectors) {
            if (!selector.isMatch(tableId)) continue;
            return true;
        }
        return false;
    }

    public static class SelectorsBuilder {
        private List<Selector> selectors;

        public SelectorsBuilder includeTables(String tableInclusions) {
            if (tableInclusions == null || tableInclusions.isEmpty()) {
                throw new IllegalArgumentException("Invalid table inclusion pattern cannot be null or empty");
            }
            ArrayList<Selector> selectors = new ArrayList<Selector>();
            Set<String> tableSplitSet = Predicates.setOf(tableInclusions, Predicates.RegExSplitterByComma::split, str -> str);
            for (String tableSplit : tableSplitSet) {
                List<String> tableIdList = Predicates.listOf(tableSplit, Predicates.RegExSplitterByDot::split, str -> str);
                Iterator<String> iterator = tableIdList.iterator();
                if (tableIdList.size() == 1) {
                    selectors.add(new Selector(null, iterator.next()));
                    continue;
                }
                if (tableIdList.size() == 2) {
                    selectors.add(new Selector(iterator.next(), iterator.next()));
                    continue;
                }
                throw new IllegalArgumentException("Invalid table inclusion pattern: " + tableInclusions);
            }
            this.selectors = selectors;
            return this;
        }

        public Selectors build() {
            Selectors selectors = new Selectors();
            selectors.selectors = this.selectors;
            return selectors;
        }
    }

    private static class Selector {
        private final Predicate<String> namespacePred;
        private final Predicate<String> tableNamePred;

        public Selector(String namespace, String tableName) {
            this.namespacePred = namespace == null ? namespacePred -> false : Predicates.includes(namespace);
            this.tableNamePred = tableName == null ? tableNamePred -> false : Predicates.includes(tableName);
        }

        public boolean isMatch(TableId tableId) {
            String namespace = tableId.catalog();
            if (namespace == null || namespace.isEmpty()) {
                return this.tableNamePred.test(tableId.table());
            }
            return this.namespacePred.test(tableId.catalog()) && this.tableNamePred.test(tableId.table());
        }
    }
}

