/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;

@PublicEvolving
public class TruncateTableEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;

    public TruncateTableEvent(TableId tableId) {
        this.tableId = tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TruncateTableEvent)) {
            return false;
        }
        TruncateTableEvent that = (TruncateTableEvent)o;
        return Objects.equals(this.tableId, that.tableId);
    }

    public int hashCode() {
        return Objects.hash(this.tableId);
    }

    public String toString() {
        return "TruncateTableEvent{tableId=" + this.tableId + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.TRUNCATE_TABLE;
    }

    @Override
    public SchemaChangeEvent copy(TableId newTableId) {
        return new TruncateTableEvent(newTableId);
    }
}

