/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.connectors.mysql.source.assigners.AssignerStatus;
import org.apache.flink.cdc.connectors.mysql.source.assigners.MySqlSplitAssigner;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.BinlogPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.connection.JdbcConnectionPools;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.util.CollectionUtil;

public class MySqlBinlogSplitAssigner
implements MySqlSplitAssigner {
    public static final String BINLOG_SPLIT_ID = "binlog-split";
    private final MySqlSourceConfig sourceConfig;
    private boolean isBinlogSplitAssigned;

    public MySqlBinlogSplitAssigner(MySqlSourceConfig sourceConfig) {
        this(sourceConfig, false);
    }

    public MySqlBinlogSplitAssigner(MySqlSourceConfig sourceConfig, BinlogPendingSplitsState checkpoint) {
        this(sourceConfig, checkpoint.isBinlogSplitAssigned());
    }

    private MySqlBinlogSplitAssigner(MySqlSourceConfig sourceConfig, boolean isBinlogSplitAssigned) {
        this.sourceConfig = sourceConfig;
        this.isBinlogSplitAssigned = isBinlogSplitAssigned;
    }

    @Override
    public void open() {
    }

    @Override
    public Optional<MySqlSplit> getNext() {
        if (this.isBinlogSplitAssigned) {
            return Optional.empty();
        }
        this.isBinlogSplitAssigned = true;
        return Optional.of(this.createBinlogSplit());
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return false;
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        return Collections.emptyList();
    }

    @Override
    public void onFinishedSplits(Map<String, BinlogOffset> splitFinishedOffsets) {
    }

    @Override
    public void addSplits(Collection<MySqlSplit> splits) {
        if (!CollectionUtil.isNullOrEmpty(splits)) {
            this.isBinlogSplitAssigned = false;
        }
    }

    @Override
    public PendingSplitsState snapshotState(long checkpointId) {
        return new BinlogPendingSplitsState(this.isBinlogSplitAssigned);
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
    }

    @Override
    public AssignerStatus getAssignerStatus() {
        return AssignerStatus.INITIAL_ASSIGNING_FINISHED;
    }

    @Override
    public boolean noMoreSplits() {
        return this.isBinlogSplitAssigned;
    }

    @Override
    public void startAssignNewlyAddedTables() {
    }

    @Override
    public void onBinlogSplitUpdated() {
    }

    @Override
    public void close() throws IOException {
        JdbcConnectionPools.getInstance().clear();
    }

    private MySqlBinlogSplit createBinlogSplit() {
        return new MySqlBinlogSplit(BINLOG_SPLIT_ID, this.sourceConfig.getStartupOptions().binlogOffset, BinlogOffset.ofNonStopping(), new ArrayList<FinishedSnapshotSplitInfo>(), new HashMap<TableId, TableChanges.TableChange>(), 0);
    }
}

