/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.schema;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.schema.MetadataColumn;
import org.apache.flink.cdc.common.schema.PhysicalColumn;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.EncodingUtils;

@PublicEvolving
public abstract class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String FIELD_FORMAT_WITH_DESCRIPTION_NO_DEFAULT_VALUE_EXPRESSION = "%s %s '%s'";
    protected static final String FIELD_FORMAT_NO_DESCRIPTION_WITH_DEFAULT_VALUE_EXPRESSION = "%s %s '%s'";
    protected static final String FIELD_FORMAT_WITH_DESCRIPTION_WITH_DEFAULT_VALUE_EXPRESSION = "%s %s '%s' '%s'";
    protected static final String FIELD_FORMAT_NO_DESCRIPTION_NO_DEFAULT_VALUE_EXPRESSION = "%s %s";
    protected final String name;
    protected final DataType type;
    @Nullable
    protected final String comment;
    @Nullable
    protected final String defaultValueExpression;

    protected Column(String name, DataType type, @Nullable String comment) {
        this.name = name;
        this.type = type;
        this.comment = comment;
        this.defaultValueExpression = null;
    }

    protected Column(String name, DataType type, @Nullable String comment, @Nullable String defaultValueExpression) {
        this.name = name;
        this.type = type;
        this.comment = comment;
        this.defaultValueExpression = defaultValueExpression;
    }

    public String getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public String getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    public String asSummaryString() {
        if (this.comment == null) {
            if (this.defaultValueExpression == null) {
                return String.format(FIELD_FORMAT_NO_DESCRIPTION_NO_DEFAULT_VALUE_EXPRESSION, EncodingUtils.escapeIdentifier(this.name), this.type.asSummaryString());
            }
            return String.format("%s %s '%s'", EncodingUtils.escapeIdentifier(this.name), this.type.asSummaryString(), this.defaultValueExpression);
        }
        if (this.defaultValueExpression == null) {
            return String.format("%s %s '%s'", EncodingUtils.escapeIdentifier(this.name), this.type.asSummaryString(), EncodingUtils.escapeSingleQuotes(this.comment));
        }
        return String.format(FIELD_FORMAT_WITH_DESCRIPTION_WITH_DEFAULT_VALUE_EXPRESSION, EncodingUtils.escapeIdentifier(this.name), this.type.asSummaryString(), EncodingUtils.escapeSingleQuotes(this.comment), this.defaultValueExpression);
    }

    public abstract boolean isPhysical();

    public abstract Column copy(DataType var1);

    public abstract Column copy(String var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column column = (Column)o;
        return this.name.equals(column.name) && this.type.equals(column.type) && Objects.equals(this.comment, column.comment) && Objects.equals(this.defaultValueExpression, column.defaultValueExpression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment, this.defaultValueExpression);
    }

    public String toString() {
        return this.asSummaryString();
    }

    public static PhysicalColumn physicalColumn(String name, DataType type, @Nullable String comment, @Nullable String defaultValueExpression) {
        return new PhysicalColumn(name, type, comment, defaultValueExpression);
    }

    public static PhysicalColumn physicalColumn(String name, DataType type, @Nullable String comment) {
        return new PhysicalColumn(name, type, comment);
    }

    public static PhysicalColumn physicalColumn(String name, DataType type) {
        return new PhysicalColumn(name, type, null);
    }

    public static MetadataColumn metadataColumn(String name, DataType type, @Nullable String metadataKey, @Nullable String comment) {
        return new MetadataColumn(name, type, metadataKey, comment);
    }

    public static MetadataColumn metadataColumn(String name, DataType type, @Nullable String metadataKey) {
        return new MetadataColumn(name, type, metadataKey, null);
    }

    public static MetadataColumn metadataColumn(String name, DataType type) {
        return new MetadataColumn(name, type, null, null);
    }
}

