/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;

@PublicEvolving
public enum SchemaChangeEventType {
    ADD_COLUMN("add.column"),
    ALTER_COLUMN_TYPE("alter.column.type"),
    CREATE_TABLE("create.table"),
    DROP_COLUMN("drop.column"),
    RENAME_COLUMN("rename.column");

    private final String tag;

    private SchemaChangeEventType(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public static SchemaChangeEventType ofEvent(SchemaChangeEvent event) {
        if (event instanceof AddColumnEvent) {
            return ADD_COLUMN;
        }
        if (event instanceof AlterColumnTypeEvent) {
            return ALTER_COLUMN_TYPE;
        }
        if (event instanceof CreateTableEvent) {
            return CREATE_TABLE;
        }
        if (event instanceof DropColumnEvent) {
            return DROP_COLUMN;
        }
        if (event instanceof RenameColumnEvent) {
            return RENAME_COLUMN;
        }
        throw new RuntimeException("Unknown schema change event type: " + event.getClass());
    }

    public static SchemaChangeEventType ofTag(String tag) {
        switch (tag) {
            case "add.column": {
                return ADD_COLUMN;
            }
            case "alter.column.type": {
                return ALTER_COLUMN_TYPE;
            }
            case "create.table": {
                return CREATE_TABLE;
            }
            case "drop.column": {
                return DROP_COLUMN;
            }
            case "rename.column": {
                return RENAME_COLUMN;
            }
        }
        throw new RuntimeException("Unknown schema change event type: " + tag);
    }
}

