/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.Immutable;
import io.debezium.document.Document;
import io.debezium.document.Value;
import io.debezium.util.Strings;
import java.util.Objects;

@Immutable
final class BasicField
implements Document.Field,
Comparable<Document.Field> {
    private final CharSequence name;
    private final Value value;

    BasicField(CharSequence name, Value value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Document.Field) {
            Document.Field that = (Document.Field)obj;
            return this.getName().equals(that.getName()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int compareTo(Document.Field that) {
        if (this == that) {
            return 0;
        }
        int diff = Strings.compareTo(this.getName(), that.getName());
        if (diff != 0) {
            return diff;
        }
        return Value.compareTo(this.getValue(), that.getValue());
    }
}

