/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.utils.Preconditions;

@PublicEvolving
public final class ZonedTimestampData
implements Comparable<ZonedTimestampData> {
    public static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final long MILLIS_PER_DAY = 86400000L;
    private final long millisecond;
    private final int nanoOfMillisecond;
    private final String zoneId;

    private ZonedTimestampData(long millisecond, int nanoOfMillisecond, String zoneId) {
        Preconditions.checkArgument(nanoOfMillisecond >= 0 && nanoOfMillisecond <= 999999);
        Preconditions.checkNotNull(zoneId);
        this.millisecond = millisecond;
        this.nanoOfMillisecond = nanoOfMillisecond;
        this.zoneId = zoneId;
    }

    public ZonedDateTime getZonedDateTime() {
        return ZonedDateTime.of(this.getLocalDateTimePart(), ZoneId.of(this.zoneId));
    }

    public Instant toInstant() {
        return ZonedDateTime.of(this.getLocalDateTimePart(), ZoneId.of(this.zoneId)).toInstant();
    }

    public Timestamp toTimestamp() {
        return Timestamp.from(this.toInstant());
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public int getNanoOfMillisecond() {
        return this.nanoOfMillisecond;
    }

    public LocalDateTime getLocalDateTimePart() {
        int date = (int)(this.millisecond / 86400000L);
        int time = (int)(this.millisecond % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        long nanoOfDay = (long)time * 1000000L + (long)this.nanoOfMillisecond;
        LocalDate localDate = LocalDate.ofEpochDay(date);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    public ZoneId getTimeZoneId() {
        return ZoneId.of(this.zoneId);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    @Override
    public int compareTo(ZonedTimestampData that) {
        long epochMillisecond = this.toInstant().getEpochSecond();
        int epochNanoOfMillisecond = this.toInstant().getNano();
        long thatEpochMillisecond = that.toInstant().getEpochSecond();
        int thatEpochNanoOfMillisecond = that.toInstant().getNano();
        int cmp = Long.compare(epochMillisecond, thatEpochMillisecond);
        if (cmp == 0) {
            cmp = epochNanoOfMillisecond - thatEpochNanoOfMillisecond;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZonedTimestampData)) {
            return false;
        }
        ZonedTimestampData that = (ZonedTimestampData)obj;
        return this.millisecond == that.millisecond && this.nanoOfMillisecond == that.nanoOfMillisecond && this.zoneId.equals(that.zoneId);
    }

    public String toString() {
        return this.getZonedDateTime().format(ISO_FORMATTER);
    }

    public int hashCode() {
        return Objects.hash(this.millisecond, this.nanoOfMillisecond, this.zoneId);
    }

    public static ZonedTimestampData fromZonedDateTime(ZonedDateTime zonedDateTime) {
        LocalDateTime dateTimePart = zonedDateTime.toLocalDateTime();
        long epochDay = dateTimePart.toLocalDate().toEpochDay();
        long nanoOfDay = dateTimePart.toLocalTime().toNanoOfDay();
        long millisecond = epochDay * 86400000L + nanoOfDay / 1000000L;
        int nanoOfMillisecond = (int)(nanoOfDay % 1000000L);
        String zoneId = zonedDateTime.getZone().toString();
        return new ZonedTimestampData(millisecond, nanoOfMillisecond, zoneId);
    }

    public static ZonedTimestampData fromOffsetDateTime(OffsetDateTime offsetDateTime) {
        return ZonedTimestampData.fromZonedDateTime(offsetDateTime.toZonedDateTime());
    }

    public static ZonedTimestampData of(long millisecond, int nanoOfMillisecond, String zoneId) {
        return new ZonedTimestampData(millisecond, nanoOfMillisecond, zoneId);
    }

    public static boolean isCompact(int precision) {
        return precision <= 3;
    }
}

