/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.errors;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.errors.ErrorHandlingMetrics;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.errors.ErrorReporter;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.errors.ProcessingContext;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReporter
implements ErrorReporter {
    private static final Logger log = LoggerFactory.getLogger(LogReporter.class);
    private static final Future<RecordMetadata> COMPLETED = CompletableFuture.completedFuture(null);
    private final ConnectorTaskId id;
    private final ConnectorConfig connConfig;
    private final ErrorHandlingMetrics errorHandlingMetrics;

    public LogReporter(ConnectorTaskId id, ConnectorConfig connConfig, ErrorHandlingMetrics errorHandlingMetrics) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(connConfig);
        Objects.requireNonNull(errorHandlingMetrics);
        this.id = id;
        this.connConfig = connConfig;
        this.errorHandlingMetrics = errorHandlingMetrics;
    }

    @Override
    public Future<RecordMetadata> report(ProcessingContext context) {
        if (!this.connConfig.enableErrorLog()) {
            return COMPLETED;
        }
        if (!context.failed()) {
            return COMPLETED;
        }
        log.error(this.message(context), context.error());
        this.errorHandlingMetrics.recordErrorLogged();
        return COMPLETED;
    }

    String message(ProcessingContext context) {
        return String.format("Error encountered in task %s. %s", this.id, context.toString(this.connConfig.includeRecordDetailsInErrorLog()));
    }
}

