/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals;

import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.Sensor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.stats.CumulativeSum;

public class KafkaProducerMetrics
implements AutoCloseable {
    public static final String GROUP = "producer-metrics";
    private static final String FLUSH = "flush";
    private static final String TXN_INIT = "txn-init";
    private static final String TXN_BEGIN = "txn-begin";
    private static final String TXN_SEND_OFFSETS = "txn-send-offsets";
    private static final String TXN_COMMIT = "txn-commit";
    private static final String TXN_ABORT = "txn-abort";
    private static final String TOTAL_TIME_SUFFIX = "-time-ns-total";
    private final Map<String, String> tags;
    private final Metrics metrics;
    private final Sensor initTimeSensor;
    private final Sensor beginTxnTimeSensor;
    private final Sensor flushTimeSensor;
    private final Sensor sendOffsetsSensor;
    private final Sensor commitTxnSensor;
    private final Sensor abortTxnSensor;

    public KafkaProducerMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.tags = this.metrics.config().tags();
        this.flushTimeSensor = this.newLatencySensor(FLUSH, "Total time producer has spent in flush in nanoseconds.");
        this.initTimeSensor = this.newLatencySensor(TXN_INIT, "Total time producer has spent in initTransactions in nanoseconds.");
        this.beginTxnTimeSensor = this.newLatencySensor(TXN_BEGIN, "Total time producer has spent in beginTransaction in nanoseconds.");
        this.sendOffsetsSensor = this.newLatencySensor(TXN_SEND_OFFSETS, "Total time producer has spent in sendOffsetsToTransaction in nanoseconds.");
        this.commitTxnSensor = this.newLatencySensor(TXN_COMMIT, "Total time producer has spent in commitTransaction in nanoseconds.");
        this.abortTxnSensor = this.newLatencySensor(TXN_ABORT, "Total time producer has spent in abortTransaction in nanoseconds.");
    }

    @Override
    public void close() {
        this.removeMetric(FLUSH);
        this.removeMetric(TXN_INIT);
        this.removeMetric(TXN_BEGIN);
        this.removeMetric(TXN_SEND_OFFSETS);
        this.removeMetric(TXN_COMMIT);
        this.removeMetric(TXN_ABORT);
    }

    public void recordFlush(long duration) {
        this.flushTimeSensor.record(duration);
    }

    public void recordInit(long duration) {
        this.initTimeSensor.record(duration);
    }

    public void recordBeginTxn(long duration) {
        this.beginTxnTimeSensor.record(duration);
    }

    public void recordSendOffsets(long duration) {
        this.sendOffsetsSensor.record(duration);
    }

    public void recordCommitTxn(long duration) {
        this.commitTxnSensor.record(duration);
    }

    public void recordAbortTxn(long duration) {
        this.abortTxnSensor.record(duration);
    }

    private Sensor newLatencySensor(String name, String description) {
        Sensor sensor = this.metrics.sensor(name + TOTAL_TIME_SUFFIX);
        sensor.add(this.metricName(name, description), new CumulativeSum());
        return sensor;
    }

    private MetricName metricName(String name, String description) {
        return this.metrics.metricName(name + TOTAL_TIME_SUFFIX, GROUP, description, this.tags);
    }

    private void removeMetric(String name) {
        this.metrics.removeSensor(name + TOTAL_TIME_SUFFIX);
    }
}

