/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.Preconditions;

@PublicEvolving
public class SchemaUtils {
    public static List<RecordData.FieldGetter> createFieldGetters(Schema schema) {
        return SchemaUtils.createFieldGetters(schema.getColumns());
    }

    public static List<RecordData.FieldGetter> createFieldGetters(List<Column> columns) {
        ArrayList<RecordData.FieldGetter> fieldGetters = new ArrayList<RecordData.FieldGetter>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            fieldGetters.add(RecordData.createFieldGetter(columns.get(i).getType(), i));
        }
        return fieldGetters;
    }

    public static Schema applySchemaChangeEvent(Schema schema, SchemaChangeEvent event) {
        if (event instanceof AddColumnEvent) {
            return SchemaUtils.applyAddColumnEvent((AddColumnEvent)event, schema);
        }
        if (event instanceof DropColumnEvent) {
            return SchemaUtils.applyDropColumnEvent((DropColumnEvent)event, schema);
        }
        if (event instanceof RenameColumnEvent) {
            return SchemaUtils.applyRenameColumnEvent((RenameColumnEvent)event, schema);
        }
        if (event instanceof AlterColumnTypeEvent) {
            return SchemaUtils.applyAlterColumnTypeEvent((AlterColumnTypeEvent)event, schema);
        }
        throw new UnsupportedOperationException(String.format("Unsupported schema change event type \"%s\"", event.getClass().getCanonicalName()));
    }

    private static Schema applyAddColumnEvent(AddColumnEvent event, Schema oldSchema) {
        LinkedList<Column> columns = new LinkedList<Column>(oldSchema.getColumns());
        for (AddColumnEvent.ColumnWithPosition columnWithPosition : event.getAddedColumns()) {
            switch (columnWithPosition.getPosition()) {
                case FIRST: {
                    columns.addFirst(columnWithPosition.getAddColumn());
                    break;
                }
                case LAST: {
                    columns.addLast(columnWithPosition.getAddColumn());
                    break;
                }
                case BEFORE: {
                    Preconditions.checkNotNull(columnWithPosition.getExistedColumnName(), "existedColumnName could not be null in BEFORE type AddColumnEvent");
                    List columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
                    int index = columnNames.indexOf(columnWithPosition.getExistedColumnName());
                    if (index < 0) {
                        throw new IllegalArgumentException(columnWithPosition.getExistedColumnName() + " of AddColumnEvent is not existed");
                    }
                    columns.add(index, columnWithPosition.getAddColumn());
                    break;
                }
                case AFTER: {
                    Preconditions.checkNotNull(columnWithPosition.getExistedColumnName(), "existedColumnName could not be null in AFTER type AddColumnEvent");
                    List columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
                    int index = columnNames.indexOf(columnWithPosition.getExistedColumnName());
                    if (index < 0) {
                        throw new IllegalArgumentException(columnWithPosition.getExistedColumnName() + " of AddColumnEvent is not existed");
                    }
                    columns.add(index + 1, columnWithPosition.getAddColumn());
                    break;
                }
            }
        }
        return oldSchema.copy(columns);
    }

    private static Schema applyDropColumnEvent(DropColumnEvent event, Schema oldSchema) {
        List<Column> columns = oldSchema.getColumns().stream().filter(column -> !event.getDroppedColumnNames().contains(column.getName())).collect(Collectors.toList());
        return oldSchema.copy(columns);
    }

    private static Schema applyRenameColumnEvent(RenameColumnEvent event, Schema oldSchema) {
        ArrayList<Column> columns = new ArrayList<Column>();
        oldSchema.getColumns().forEach(column -> {
            if (event.getNameMapping().containsKey(column.getName())) {
                columns.add(column.copy(event.getNameMapping().get(column.getName())));
            } else {
                columns.add((Column)column);
            }
        });
        return oldSchema.copy(columns);
    }

    private static Schema applyAlterColumnTypeEvent(AlterColumnTypeEvent event, Schema oldSchema) {
        ArrayList<Column> columns = new ArrayList<Column>();
        oldSchema.getColumns().forEach(column -> {
            if (event.getTypeMapping().containsKey(column.getName())) {
                columns.add(column.copy(event.getTypeMapping().get(column.getName())));
            } else {
                columns.add((Column)column);
            }
        });
        return oldSchema.copy(columns);
    }
}

