/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;

public class ChangeEventUtils {
    public static DataChangeEvent recreateDataChangeEvent(DataChangeEvent dataChangeEvent, TableId tableId) {
        switch (dataChangeEvent.op()) {
            case INSERT: {
                return DataChangeEvent.insertEvent(tableId, dataChangeEvent.after(), dataChangeEvent.meta());
            }
            case UPDATE: {
                return DataChangeEvent.updateEvent(tableId, dataChangeEvent.before(), dataChangeEvent.after(), dataChangeEvent.meta());
            }
            case REPLACE: {
                return DataChangeEvent.replaceEvent(tableId, dataChangeEvent.after(), dataChangeEvent.meta());
            }
            case DELETE: {
                return DataChangeEvent.deleteEvent(tableId, dataChangeEvent.before(), dataChangeEvent.meta());
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported operation type \"%s\" in data change event", new Object[]{dataChangeEvent.op()}));
    }

    public static SchemaChangeEvent recreateSchemaChangeEvent(SchemaChangeEvent schemaChangeEvent, TableId tableId) {
        if (schemaChangeEvent instanceof CreateTableEvent) {
            CreateTableEvent createTableEvent = (CreateTableEvent)schemaChangeEvent;
            return new CreateTableEvent(tableId, createTableEvent.getSchema());
        }
        if (schemaChangeEvent instanceof AlterColumnTypeEvent) {
            AlterColumnTypeEvent alterColumnTypeEvent = (AlterColumnTypeEvent)schemaChangeEvent;
            return new AlterColumnTypeEvent(tableId, alterColumnTypeEvent.getTypeMapping());
        }
        if (schemaChangeEvent instanceof RenameColumnEvent) {
            RenameColumnEvent renameColumnEvent = (RenameColumnEvent)schemaChangeEvent;
            return new RenameColumnEvent(tableId, renameColumnEvent.getNameMapping());
        }
        if (schemaChangeEvent instanceof DropColumnEvent) {
            DropColumnEvent dropColumnEvent = (DropColumnEvent)schemaChangeEvent;
            return new DropColumnEvent(tableId, dropColumnEvent.getDroppedColumnNames());
        }
        if (schemaChangeEvent instanceof AddColumnEvent) {
            AddColumnEvent addColumnEvent = (AddColumnEvent)schemaChangeEvent;
            return new AddColumnEvent(tableId, addColumnEvent.getAddedColumns());
        }
        throw new UnsupportedOperationException(String.format("Unsupported schema change event with type \"%s\"", schemaChangeEvent.getClass().getCanonicalName()));
    }
}

