/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableEditorImpl;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class TableImpl
implements Table {
    private final TableId id;
    private final List<Column> columnDefs;
    private final List<String> pkColumnNames;
    private final Map<String, Column> columnsByLowercaseName;
    private final String defaultCharsetName;
    private final String comment;

    TableImpl(Table table) {
        this(table.id(), table.columns(), table.primaryKeyColumnNames(), table.defaultCharsetName(), table.comment());
    }

    TableImpl(TableId id, List<Column> sortedColumns, List<String> pkColumnNames, String defaultCharsetName, String comment) {
        this.id = id;
        this.columnDefs = Collections.unmodifiableList(sortedColumns);
        this.pkColumnNames = pkColumnNames == null ? Collections.emptyList() : Collections.unmodifiableList(pkColumnNames);
        LinkedHashMap<String, Column> defsByLowercaseName = new LinkedHashMap<String, Column>();
        for (Column def : this.columnDefs) {
            defsByLowercaseName.put(def.name().toLowerCase(), def);
        }
        this.columnsByLowercaseName = Collections.unmodifiableMap(defsByLowercaseName);
        this.defaultCharsetName = defaultCharsetName;
        this.comment = comment;
    }

    @Override
    public TableId id() {
        return this.id;
    }

    @Override
    public List<String> primaryKeyColumnNames() {
        return this.pkColumnNames;
    }

    @Override
    public List<Column> columns() {
        return this.columnDefs;
    }

    @Override
    public List<String> retrieveColumnNames() {
        return this.columnDefs.stream().map(Column::name).collect(Collectors.toList());
    }

    @Override
    public Column columnWithName(String name) {
        return this.columnsByLowercaseName.get(name.toLowerCase());
    }

    @Override
    public String defaultCharsetName() {
        return this.defaultCharsetName;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table that = (Table)obj;
            return this.id().equals(that.id()) && this.columns().equals(that.columns()) && this.primaryKeyColumnNames().equals(that.primaryKeyColumnNames()) && Strings.equalsIgnoreCase(this.defaultCharsetName(), that.defaultCharsetName());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    public void toString(StringBuilder sb, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        sb.append(prefix).append("columns: {").append(System.lineSeparator());
        for (Column defn : this.columnDefs) {
            sb.append(prefix).append("  ").append(defn).append(System.lineSeparator());
        }
        sb.append(prefix).append("}").append(System.lineSeparator());
        sb.append(prefix).append("primary key: ").append(this.primaryKeyColumnNames()).append(System.lineSeparator());
        sb.append(prefix).append("default charset: ").append(this.defaultCharsetName()).append(System.lineSeparator());
        sb.append(prefix).append("comment: ").append(this.comment()).append(System.lineSeparator());
    }

    @Override
    public TableEditor edit() {
        return new TableEditorImpl().tableId(this.id).setColumns(this.columnDefs).setPrimaryKeyNames(this.pkColumnNames).setDefaultCharsetName(this.defaultCharsetName).setComment(this.comment);
    }
}

