/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;

@PublicEvolving
public class CreateTableEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final Schema schema;

    public CreateTableEvent(TableId tableId, Schema schema) {
        this.tableId = tableId;
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTableEvent)) {
            return false;
        }
        CreateTableEvent that = (CreateTableEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.schema);
    }

    public String toString() {
        return "CreateTableEvent{tableId=" + this.tableId + ", schema=" + this.schema + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.CREATE_TABLE;
    }

    @Override
    public SchemaChangeEvent copy(TableId newTableId) {
        return new CreateTableEvent(newTableId, this.schema);
    }
}

