/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.Node;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class AlterConsumerGroupOffsetsHandler
extends AdminApiHandler.Batched<CoordinatorKey, Map<TopicPartition, Errors>> {
    private final CoordinatorKey groupId;
    private final Map<TopicPartition, OffsetAndMetadata> offsets;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public AlterConsumerGroupOffsetsHandler(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, LogContext logContext) {
        this.groupId = CoordinatorKey.byGroupId(groupId);
        this.offsets = offsets;
        this.log = logContext.logger(AlterConsumerGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    @Override
    public String apiName() {
        return "offsetCommit";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, Errors>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Collections.singleton(CoordinatorKey.byGroupId(groupId)));
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        if (!groupIds.equals(Collections.singleton(this.groupId))) {
            throw new IllegalArgumentException("Received unexpected group ids " + groupIds + " (expected only " + Collections.singleton(this.groupId) + ")");
        }
    }

    public OffsetCommitRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        HashMap offsetData = new HashMap();
        this.offsets.forEach((topicPartition, offsetAndMetadata) -> {
            OffsetCommitRequestData.OffsetCommitRequestTopic topic = offsetData.computeIfAbsent(topicPartition.topic(), key -> new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicPartition.topic()));
            topic.partitions().add(new OffsetCommitRequestData.OffsetCommitRequestPartition().setCommittedOffset(offsetAndMetadata.offset()).setCommittedLeaderEpoch(offsetAndMetadata.leaderEpoch().orElse(-1)).setCommittedMetadata(offsetAndMetadata.metadata()).setPartitionIndex(topicPartition.partition()));
        });
        OffsetCommitRequestData data = new OffsetCommitRequestData().setGroupId(this.groupId.idValue).setTopics(new ArrayList<OffsetCommitRequestData.OffsetCommitRequestTopic>(offsetData.values()));
        return new OffsetCommitRequest.Builder(data);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        OffsetCommitResponse response = (OffsetCommitResponse)abstractResponse;
        HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
        HashSet<CoordinatorKey> groupsToRetry = new HashSet<CoordinatorKey>();
        HashMap<TopicPartition, Errors> partitionResults = new HashMap<TopicPartition, Errors>();
        for (OffsetCommitResponseData.OffsetCommitResponseTopic topic : response.data().topics()) {
            for (OffsetCommitResponseData.OffsetCommitResponsePartition partition : topic.partitions()) {
                TopicPartition topicPartition = new TopicPartition(topic.name(), partition.partitionIndex());
                Errors error = Errors.forCode(partition.errorCode());
                if (error != Errors.NONE) {
                    this.handleError(this.groupId, topicPartition, error, partitionResults, groupsToUnmap, groupsToRetry);
                    continue;
                }
                partitionResults.put(topicPartition, error);
            }
        }
        if (groupsToUnmap.isEmpty() && groupsToRetry.isEmpty()) {
            return AdminApiHandler.ApiResult.completed(this.groupId, partitionResults);
        }
        return AdminApiHandler.ApiResult.unmapped(new ArrayList(groupsToUnmap));
    }

    private void handleError(CoordinatorKey groupId, TopicPartition topicPartition, Errors error, Map<TopicPartition, Errors> partitionResults, Set<CoordinatorKey> groupsToUnmap, Set<CoordinatorKey> groupsToRetry) {
        switch (error) {
            case COORDINATOR_LOAD_IN_PROGRESS: 
            case REBALANCE_IN_PROGRESS: {
                this.log.debug("OffsetCommit request for group id {} returned error {}. Will retry.", (Object)groupId.idValue, (Object)error);
                groupsToRetry.add(groupId);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("OffsetCommit request for group id {} returned error {}. Will rediscover the coordinator and retry.", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            case INVALID_GROUP_ID: 
            case INVALID_COMMIT_OFFSET_SIZE: 
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("OffsetCommit request for group id {} failed due to error {}.", (Object)groupId.idValue, (Object)error);
                partitionResults.put(topicPartition, error);
                break;
            }
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case OFFSET_METADATA_TOO_LARGE: 
            case TOPIC_AUTHORIZATION_FAILED: {
                this.log.debug("OffsetCommit request for group id {} and partition {} failed due to error {}.", new Object[]{groupId.idValue, topicPartition, error});
                partitionResults.put(topicPartition, error);
                break;
            }
            default: {
                this.log.error("OffsetCommit request for group id {} and partition {} failed due to unexpected error {}.", new Object[]{groupId.idValue, topicPartition, error});
                partitionResults.put(topicPartition, error);
            }
        }
    }
}

