/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.connection;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClientPool {
    private static final Logger LOG = LoggerFactory.getLogger(MongoClientPool.class);
    private static final MongoClientPool INSTANCE = new MongoClientPool();
    private final Map<String, MongoClient> pools = new ConcurrentHashMap<String, MongoClient>();

    private MongoClientPool() {
    }

    public static MongoClientPool getInstance() {
        return INSTANCE;
    }

    public MongoClient getOrCreateMongoClient(MongoDBSourceConfig sourceConfig) {
        return this.pools.computeIfAbsent(sourceConfig.getConnectionString(), rawConnectionString -> {
            ConnectionString connectionString = new ConnectionString((String)rawConnectionString);
            LOG.info("Create and register mongo client {}@{}", (Object)connectionString.getUsername(), connectionString.getHosts());
            return MongoClients.create(connectionString);
        });
    }
}

