/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.pipeline.signal.Signal;
import io.debezium.pipeline.spi.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log<P extends Partition>
implements Signal.Action<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Log.class);
    private static final String FIELD_MESSAGE = "message";
    public static final String NAME = "log";

    @Override
    public boolean arrived(Signal.Payload<P> signalPayload) {
        String message = signalPayload.data.getString(FIELD_MESSAGE);
        if (message == null || message.isEmpty()) {
            LOGGER.warn("Logging signal '{}' has arrived but the requested field '{}' is missing from data", signalPayload, (Object)FIELD_MESSAGE);
            return false;
        }
        LOGGER.info(message, signalPayload.offsetContext != null ? signalPayload.offsetContext.getOffset() : "<none>");
        return true;
    }
}

