/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx.internal;

import com.mongodb.kafka.connect.util.jmx.internal.Metric;
import com.mongodb.kafka.connect.util.jmx.internal.MetricValue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class LatestMetric
implements Metric {
    private final String name;
    private final AtomicBoolean wasSampled = new AtomicBoolean();
    private final AtomicLong value = new AtomicLong();

    public LatestMetric(String name) {
        this.name = name;
    }

    @Override
    public void sample(long v) {
        this.value.set(v);
        this.wasSampled.set(true);
    }

    @Override
    public void emit(Consumer<MetricValue> consumer) {
        consumer.accept(new MetricValue.LatestMetricValue(this.name, () -> {
            if (this.wasSampled.get()) {
                return this.value.get();
            }
            return null;
        }));
    }
}

