/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.id.strategy;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import java.util.UUID;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;

public class UuidStrategy
implements IdStrategy {
    private MongoSinkTopicConfig.UuidBsonFormat outputFormat;

    @Override
    public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
        UUID uuid = UUID.randomUUID();
        if (this.outputFormat.equals((Object)MongoSinkTopicConfig.UuidBsonFormat.STRING)) {
            return new BsonString(uuid.toString());
        }
        return new BsonBinary(uuid, UuidRepresentation.STANDARD);
    }

    @Override
    public void configure(MongoSinkTopicConfig configuration) {
        this.outputFormat = MongoSinkTopicConfig.UuidBsonFormat.valueOf(configuration.getString("document.id.strategy.uuid.format").toUpperCase());
    }
}

