/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonInt64;
import org.bson.BsonString;

public class KafkaMetaAdder
extends PostProcessor {
    private static final String KAFKA_META_DATA = "topic-partition-offset";

    public KafkaMetaAdder(MongoSinkTopicConfig config) {
        super(config);
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        doc.getValueDoc().ifPresent(vd -> {
            vd.put(KAFKA_META_DATA, new BsonString(String.format("%s-%s-%s", orig.topic(), orig.kafkaPartition(), orig.kafkaOffset())));
            if (orig.timestampType() != null && orig.timestamp() != null) {
                vd.put(orig.timestampType().name(), new BsonInt64(orig.timestamp()));
            }
        });
    }
}

