/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect;

import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.MongoSourceTask;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectionValidator;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.Config;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.Task;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;

public class MongoSourceConnector
extends SourceConnector {
    private static final List<String> REQUIRED_SOURCE_ACTIONS = Arrays.asList("changeStream", "find");
    private Map<String, String> settings;

    @Override
    public void start(Map<String, String> props) {
        this.settings = props;
    }

    @Override
    public Class<? extends Task> taskClass() {
        return MongoSourceTask.class;
    }

    @Override
    public Config validate(Map<String, String> connectorConfigs) {
        MongoSourceConfig sourceConfig;
        try {
            sourceConfig = new MongoSourceConfig(connectorConfigs);
        }
        catch (Exception e) {
            return super.validate(connectorConfigs);
        }
        Map<String, String> resolvedConnectorConfigs = ConfigHelper.evaluateConfigValues(connectorConfigs, (AbstractConfig)sourceConfig);
        Config tempConfig = super.validate(resolvedConnectorConfigs);
        Config config = ConfigHelper.evaluateConfigValues(tempConfig, (AbstractConfig)sourceConfig);
        ConnectionValidator.validateCanConnect(sourceConfig, config, "connection.uri").ifPresent(client -> {
            try {
                ServerApiConfig.validateServerApi(client, config);
                ConnectionValidator.validateUserHasActions(client, sourceConfig.getConnectionString().getCredential(), REQUIRED_SOURCE_ACTIONS, sourceConfig.getString("database"), sourceConfig.getString("collection"), "connection.uri", config);
            }
            catch (Exception exception) {
            }
            finally {
                client.close();
            }
        });
        return config;
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        return Collections.singletonList(this.settings);
    }

    @Override
    public void stop() {
    }

    @Override
    public ConfigDef config() {
        return MongoSourceConfig.CONFIG;
    }

    @Override
    public String version() {
        return "1.13.0";
    }
}

