/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.utils;

import com.mongodb.kafka.connect.source.schema.BsonValueToSchemaAndValue;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.cdc.connectors.base.source.meta.wartermark.WatermarkEvent;
import org.apache.flink.cdc.connectors.mongodb.internal.MongoDBEnvelope;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.json.JsonWriterSettings;

public class MongoRecordUtils {
    private MongoRecordUtils() {
    }

    public static boolean isSnapshotRecord(SourceRecord sourceRecord) {
        return "true".equals(MongoRecordUtils.getOffsetValue(sourceRecord, "copy"));
    }

    public static boolean isHeartbeatEvent(SourceRecord sourceRecord) {
        return "true".equals(MongoRecordUtils.getOffsetValue(sourceRecord, "HEARTBEAT"));
    }

    public static boolean isDataChangeRecord(SourceRecord sourceRecord) {
        return !WatermarkEvent.isWatermarkEvent(sourceRecord) && !MongoRecordUtils.isHeartbeatEvent(sourceRecord);
    }

    public static BsonDocument getResumeToken(SourceRecord sourceRecord) {
        return BsonDocument.parse(MongoRecordUtils.getOffsetValue(sourceRecord, "_id"));
    }

    public static BsonDocument getDocumentKey(SourceRecord sourceRecord) {
        Struct value = (Struct)sourceRecord.value();
        return BsonDocument.parse(value.getString("documentKey"));
    }

    public static String getOffsetValue(SourceRecord sourceRecord, String key) {
        return (String)sourceRecord.sourceOffset().get(key);
    }

    public static Long getMessageTimestamp(SourceRecord sourceRecord) {
        if (MongoRecordUtils.isHeartbeatEvent(sourceRecord)) {
            return MongoRecordUtils.getMessageTimestampFromHeartbeatEvent(sourceRecord);
        }
        Struct value = (Struct)sourceRecord.value();
        Struct source = value.getStruct("source");
        return source.getInt64("ts_ms");
    }

    public static Long getMessageTimestampFromHeartbeatEvent(SourceRecord sourceRecord) {
        Struct value = (Struct)sourceRecord.value();
        return value.getInt64("ts_ms");
    }

    public static Long getFetchTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("ts_ms") == null) {
            return null;
        }
        return value.getInt64("ts_ms");
    }

    public static TableId getTableId(SourceRecord dataRecord) {
        Struct value = (Struct)dataRecord.value();
        Struct source = value.getStruct("ns");
        String dbName = source.getString("db");
        String collName = source.getString("coll");
        return new TableId(dbName, null, collName);
    }

    public static BsonTimestamp currentBsonTimestamp() {
        return MongoRecordUtils.bsonTimestampFromEpochMillis(System.currentTimeMillis());
    }

    public static BsonTimestamp maximumBsonTimestamp() {
        return new BsonTimestamp(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static BsonTimestamp bsonTimestampFromEpochMillis(long epochMillis) {
        return new BsonTimestamp((int)Instant.ofEpochMilli(epochMillis).getEpochSecond(), 1);
    }

    public static SourceRecord createSourceRecord(Map<String, String> partition, Map<String, String> sourceOffset, String topicName, BsonDocument keyDocument, BsonDocument valueDocument) {
        return MongoRecordUtils.createSourceRecord(partition, sourceOffset, topicName, keyDocument, valueDocument, MongoDBEnvelope.JSON_WRITER_SETTINGS_STRICT);
    }

    public static SourceRecord createSourceRecord(Map<String, String> partition, Map<String, String> sourceOffset, String topicName, BsonDocument keyDocument, BsonDocument valueDocument, JsonWriterSettings jsonWriterSettings) {
        BsonValueToSchemaAndValue schemaAndValue = new BsonValueToSchemaAndValue(jsonWriterSettings);
        SchemaAndValue keySchemaAndValue = schemaAndValue.toSchemaAndValue(MongoDBEnvelope.SOURCE_RECORD_KEY_SCHEMA, keyDocument);
        SchemaAndValue valueSchemaAndValue = schemaAndValue.toSchemaAndValue(MongoDBEnvelope.SOURCE_RECORD_VALUE_SCHEMA, valueDocument);
        return new SourceRecord(partition, sourceOffset, topicName, keySchemaAndValue.schema(), keySchemaAndValue.value(), valueSchemaAndValue.schema(), valueSchemaAndValue.value());
    }

    public static Map<String, String> createSourceOffsetMap(BsonDocument idDocument, boolean isSnapshotRecord) {
        HashMap<String, String> sourceOffset = new HashMap<String, String>();
        sourceOffset.put("_id", idDocument.toJson());
        sourceOffset.put("copy", String.valueOf(isSnapshotRecord));
        return sourceOffset;
    }

    public static Map<String, String> createPartitionMap(String scheme, String hosts, String database, String collection) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s://", scheme));
        builder.append(hosts);
        builder.append("/");
        if (StringUtils.isNotEmpty((CharSequence)database)) {
            builder.append(database);
        }
        if (StringUtils.isNotEmpty((CharSequence)collection)) {
            builder.append(".");
            builder.append(collection);
        }
        return Collections.singletonMap("ns", builder.toString());
    }

    public static Map<String, Object> createHeartbeatPartitionMap(String scheme, String hosts) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s://", scheme));
        builder.append(hosts);
        builder.append("/");
        builder.append("__mongodb_heartbeats");
        return Collections.singletonMap("ns", builder.toString());
    }

    public static Map<String, String> createWatermarkPartitionMap(String partition) {
        return Collections.singletonMap("ns", partition);
    }
}

