/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.mongodb;

import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.debezium.DebeziumCdcHandler;
import com.mongodb.kafka.connect.sink.cdc.debezium.OperationType;
import com.mongodb.kafka.connect.sink.cdc.debezium.mongodb.MongoDbDelete;
import com.mongodb.kafka.connect.sink.cdc.debezium.mongodb.MongoDbInsert;
import com.mongodb.kafka.connect.sink.cdc.debezium.mongodb.MongoDbUpdate;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbHandler
extends DebeziumCdcHandler {
    static final String ID_FIELD = "_id";
    static final String JSON_ID_FIELD = "id";
    private static final Map<OperationType, CdcOperation> DEFAULT_OPERATIONS = new HashMap<OperationType, CdcOperation>(){
        {
            this.put(OperationType.CREATE, new MongoDbInsert());
            this.put(OperationType.READ, new MongoDbInsert());
            this.put(OperationType.UPDATE, new MongoDbUpdate(MongoDbUpdate.EventFormat.Oplog));
            this.put(OperationType.DELETE, new MongoDbDelete());
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbHandler.class);

    public MongoDbHandler(MongoSinkTopicConfig config) {
        this(config, DEFAULT_OPERATIONS);
    }

    public MongoDbHandler(MongoSinkTopicConfig config, Map<OperationType, CdcOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseGet(BsonDocument::new);
        if (keyDoc.isEmpty()) {
            throw new DataException("Key document must not be missing for CDC mode");
        }
        BsonDocument valueDoc = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (keyDoc.containsKey(JSON_ID_FIELD) && valueDoc.isEmpty()) {
            LOGGER.debug("Skipping debezium tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        LOGGER.debug("key: {}", (Object)keyDoc);
        LOGGER.debug("value: {}", (Object)valueDoc);
        return Optional.of(this.getCdcOperation(valueDoc).perform(doc));
    }
}

