/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.kafka.connect.sink.MongoProcessedSinkRecordData;
import com.mongodb.kafka.connect.sink.MongoSinkConfig;
import com.mongodb.kafka.connect.sink.dlq.ErrorReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoSinkRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoSinkRecordProcessor.class);

    static List<List<MongoProcessedSinkRecordData>> orderedGroupByTopicAndNamespace(Collection<SinkRecord> records, MongoSinkConfig sinkConfig, ErrorReporter errorReporter) {
        LOGGER.debug("Number of sink records to process: {}", (Object)records.size());
        ArrayList<List<MongoProcessedSinkRecordData>> orderedProcessedSinkRecordData = new ArrayList<List<MongoProcessedSinkRecordData>>();
        ArrayList<MongoProcessedSinkRecordData> currentGroup = new ArrayList<MongoProcessedSinkRecordData>();
        MongoProcessedSinkRecordData previous = null;
        for (SinkRecord record : records) {
            int maxBatchSize;
            MongoProcessedSinkRecordData processedData = new MongoProcessedSinkRecordData(record, sinkConfig);
            if (processedData.getException() != null) {
                errorReporter.report(processedData.getSinkRecord(), processedData.getException());
                continue;
            }
            if (processedData.getNamespace() == null || processedData.getWriteModel() == null) continue;
            if (previous == null) {
                previous = processedData;
            }
            if ((maxBatchSize = processedData.getConfig().getInt("max.batch.size").intValue()) > 0 && currentGroup.size() == maxBatchSize || !previous.getSinkRecord().topic().equals(processedData.getSinkRecord().topic()) || !previous.getNamespace().equals(processedData.getNamespace())) {
                orderedProcessedSinkRecordData.add(currentGroup);
                currentGroup = new ArrayList();
            }
            previous = processedData;
            currentGroup.add(processedData);
        }
        if (!currentGroup.isEmpty()) {
            orderedProcessedSinkRecordData.add(currentGroup);
        }
        return orderedProcessedSinkRecordData;
    }

    private MongoSinkRecordProcessor() {
    }
}

