/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect;

import com.mongodb.kafka.connect.sink.MongoSinkConfig;
import com.mongodb.kafka.connect.sink.MongoSinkTask;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectionValidator;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import com.mongodb.kafka.connect.util.TimeseriesValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.Config;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.Task;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkConnector;

public class MongoSinkConnector
extends SinkConnector {
    private static final List<String> REQUIRED_SINK_ACTIONS = Arrays.asList("insert", "update", "remove");
    private static final List<String> REQUIRED_COLLSTATS_SINK_ACTIONS = Arrays.asList("insert", "update", "remove", "collStats");
    private Map<String, String> settings;

    @Override
    public String version() {
        return "1.13.0";
    }

    @Override
    public void start(Map<String, String> map) {
        this.settings = map;
    }

    @Override
    public Class<? extends Task> taskClass() {
        return MongoSinkTask.class;
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.settings);
        }
        return configs;
    }

    @Override
    public void stop() {
    }

    @Override
    public ConfigDef config() {
        return MongoSinkConfig.CONFIG;
    }

    @Override
    public Config validate(Map<String, String> connectorConfigs) {
        MongoSinkConfig sinkConfig;
        try {
            sinkConfig = new MongoSinkConfig(connectorConfigs);
        }
        catch (Exception e) {
            return super.validate(connectorConfigs);
        }
        Map<String, String> resolvedConnectorConfigs = ConfigHelper.evaluateConfigValues(connectorConfigs, (AbstractConfig)sinkConfig);
        Config tempConfig = super.validate(resolvedConnectorConfigs);
        Config config = ConfigHelper.evaluateConfigValues(tempConfig, (AbstractConfig)sinkConfig);
        ConnectionValidator.validateCanConnect(sinkConfig, config, "connection.uri").ifPresent(client -> {
            try {
                ServerApiConfig.validateServerApi(client, config);
                sinkConfig.getTopics().ifPresent(topics -> topics.forEach(topic -> {
                    MongoSinkTopicConfig mongoSinkTopicConfig = sinkConfig.getMongoSinkTopicConfig((String)topic);
                    ConnectionValidator.validateUserHasActions(client, sinkConfig.getConnectionString().getCredential(), mongoSinkTopicConfig.isTimeseries() ? REQUIRED_COLLSTATS_SINK_ACTIONS : REQUIRED_SINK_ACTIONS, mongoSinkTopicConfig.getString("database"), mongoSinkTopicConfig.getString("collection"), "connection.uri", config);
                    TimeseriesValidation.validateConfigAndCollection(client, mongoSinkTopicConfig, config);
                }));
                sinkConfig.getTopicRegex().ifPresent(regex -> {
                    ConnectionValidator.validateUserHasActions(client, sinkConfig.getConnectionString().getCredential(), REQUIRED_SINK_ACTIONS, ConfigHelper.getConfigByName(config, "database").map(c -> (String)c.value()).orElse(""), ConfigHelper.getConfigByName(config, "collection").map(c -> (String)c.value()).orElse(""), "connection.uri", config);
                    TimeseriesValidation.validTopicRegexConfigAndCollection(client, sinkConfig, config);
                });
            }
            catch (Exception exception) {
            }
            finally {
                client.close();
            }
        });
        return config;
    }
}

