/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.runtime.serializer.InternalSerializers;
import org.apache.flink.cdc.runtime.serializer.data.writer.BinaryRecordDataWriter;
import org.apache.flink.cdc.runtime.serializer.data.writer.BinaryWriter;

@PublicEvolving
public class BinaryRecordDataGenerator {
    private final DataType[] dataTypes;
    private final TypeSerializer[] serializers;
    private transient BinaryRecordData reuseRecordData;
    private transient BinaryRecordDataWriter reuseWriter;

    public BinaryRecordDataGenerator(RowType recordType) {
        this(recordType.getChildren().toArray(new DataType[0]));
    }

    public BinaryRecordDataGenerator(DataType[] dataTypes) {
        this(dataTypes, (TypeSerializer[])Arrays.stream(dataTypes).map(InternalSerializers::create).toArray(TypeSerializer[]::new));
    }

    public BinaryRecordDataGenerator(DataType[] dataTypes, TypeSerializer[] serializers) {
        Preconditions.checkArgument(dataTypes.length == serializers.length, "The types and serializers must have the same length. But types is %s and serializers is %s", dataTypes.length, serializers.length);
        this.dataTypes = dataTypes;
        this.serializers = serializers;
        this.reuseRecordData = new BinaryRecordData(dataTypes.length);
        this.reuseWriter = new BinaryRecordDataWriter(this.reuseRecordData);
    }

    public BinaryRecordData generate(Object[] rowFields) {
        Preconditions.checkArgument(this.dataTypes.length == rowFields.length, "The types and values must have the same length. But types is %s and values is %s", this.dataTypes.length, rowFields.length);
        this.reuseWriter.reset();
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (rowFields[i] == null) {
                this.reuseWriter.setNullAt(i);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, rowFields[i], this.dataTypes[i], this.serializers[i]);
        }
        this.reuseWriter.complete();
        return this.reuseRecordData.copy();
    }
}

