/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;

public class TransformProjection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String projection;
    private final List<ProjectionColumn> projectionColumns;

    public TransformProjection(String projection, List<ProjectionColumn> projectionColumns) {
        this.projection = projection;
        this.projectionColumns = projectionColumns;
    }

    public String getProjection() {
        return this.projection;
    }

    public List<ProjectionColumn> getProjectionColumns() {
        return this.projectionColumns;
    }

    public boolean isValid() {
        return !StringUtils.isNullOrWhitespaceOnly(this.projection);
    }

    public static Optional<TransformProjection> of(String projection) {
        if (StringUtils.isNullOrWhitespaceOnly(projection)) {
            return Optional.empty();
        }
        return Optional.of(new TransformProjection(projection, new ArrayList<ProjectionColumn>()));
    }

    public String toString() {
        return "TransformProjection{projection='" + this.getProjection() + '\'' + ", projectionColumns=" + this.getProjectionColumns() + '}';
    }
}

