/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;

@PublicEvolving
public final class AddColumnEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final List<ColumnWithPosition> addedColumns;

    public AddColumnEvent(TableId tableId, List<ColumnWithPosition> addedColumns) {
        this.tableId = tableId;
        this.addedColumns = addedColumns;
    }

    public static ColumnWithPosition first(Column addColumn) {
        return new ColumnWithPosition(addColumn, ColumnPosition.FIRST, null);
    }

    public static ColumnWithPosition last(Column addColumn) {
        return new ColumnWithPosition(addColumn, ColumnPosition.LAST, null);
    }

    public static ColumnWithPosition before(Column addColumn, String existedColumnName) {
        return new ColumnWithPosition(addColumn, ColumnPosition.BEFORE, existedColumnName);
    }

    public static ColumnWithPosition after(Column addColumn, String existedColumnName) {
        return new ColumnWithPosition(addColumn, ColumnPosition.AFTER, existedColumnName);
    }

    public List<ColumnWithPosition> getAddedColumns() {
        return this.addedColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddColumnEvent)) {
            return false;
        }
        AddColumnEvent that = (AddColumnEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.addedColumns, that.addedColumns);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.addedColumns);
    }

    public String toString() {
        return "AddColumnEvent{tableId=" + this.tableId + ", addedColumns=" + this.addedColumns + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.ADD_COLUMN;
    }

    @Override
    public SchemaChangeEvent copy(TableId newTableId) {
        return new AddColumnEvent(newTableId, this.addedColumns);
    }

    public static class ColumnWithPosition
    implements Serializable {
        private final Column addColumn;
        private final ColumnPosition position;
        @Nullable
        private final String existedColumnName;

        public ColumnWithPosition(Column addColumn) {
            this.addColumn = addColumn;
            this.position = ColumnPosition.LAST;
            this.existedColumnName = null;
        }

        public ColumnWithPosition(Column addColumn, ColumnPosition position, @Nullable String existedColumnName) {
            this.addColumn = addColumn;
            this.position = position;
            this.existedColumnName = existedColumnName;
        }

        public Column getAddColumn() {
            return this.addColumn;
        }

        public ColumnPosition getPosition() {
            return this.position;
        }

        @Nullable
        public String getExistedColumnName() {
            return this.existedColumnName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnWithPosition)) {
                return false;
            }
            ColumnWithPosition position1 = (ColumnWithPosition)o;
            return Objects.equals(this.addColumn, position1.addColumn) && this.position == position1.position && Objects.equals(this.existedColumnName, position1.existedColumnName);
        }

        public int hashCode() {
            return Objects.hash(this.addColumn, this.position, this.existedColumnName);
        }

        public String toString() {
            return "ColumnWithPosition{column=" + this.addColumn + ", position=" + this.position + ", existedColumnName=" + this.existedColumnName + '}';
        }
    }

    public static enum ColumnPosition implements Serializable
    {
        BEFORE,
        AFTER,
        FIRST,
        LAST;

    }
}

