/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.pipeline.spi.Partition;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.MDC;

public class LoggingContext {
    public static final String CONNECTOR_TYPE = "dbz.connectorType";
    public static final String CONNECTOR_NAME = "dbz.connectorName";
    public static final String CONNECTOR_CONTEXT = "dbz.connectorContext";
    public static final String TASK_ID = "dbz.taskId";
    public static final String DATABASE_NAME = "dbz.databaseName";

    private LoggingContext() {
    }

    public static PreviousContext forConnector(String connectorType, String connectorName, String contextName) {
        return LoggingContext.forConnector(connectorType, connectorName, null, contextName, null);
    }

    public static PreviousContext forConnector(String connectorType, String connectorName, String taskId, String contextName, Partition partition) {
        Objects.requireNonNull(connectorType, "The MDC value for the connector type may not be null");
        Objects.requireNonNull(connectorName, "The MDC value for the connector name may not be null");
        Objects.requireNonNull(contextName, "The MDC value for the connector context may not be null");
        PreviousContext previous = new PreviousContext();
        if (taskId != null) {
            MDC.put(TASK_ID, taskId);
        }
        if (partition != null) {
            partition.getLoggingContext().forEach(MDC::put);
        }
        MDC.put(CONNECTOR_TYPE, connectorType);
        MDC.put(CONNECTOR_NAME, connectorName);
        MDC.put(CONNECTOR_CONTEXT, contextName);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void temporarilyForConnector(String connectorType, String connectorName, String contextName, Runnable operation) {
        Objects.requireNonNull(connectorType, "The MDC value for the connector type may not be null");
        Objects.requireNonNull(connectorName, "The MDC value for the connector name may not be null");
        Objects.requireNonNull(contextName, "The MDC value for the connector context may not be null");
        Objects.requireNonNull(operation, "The operation may not be null");
        PreviousContext previous = new PreviousContext();
        try {
            LoggingContext.forConnector(connectorType, connectorName, contextName);
            operation.run();
        }
        finally {
            previous.restore();
        }
    }

    public static final class PreviousContext {
        private static final Map<String, String> EMPTY_CONTEXT = Collections.emptyMap();
        private final Map<String, String> context;

        protected PreviousContext() {
            Map<String, String> context = MDC.getCopyOfContextMap();
            this.context = context != null ? context : EMPTY_CONTEXT;
        }

        public void restore() {
            MDC.setContextMap(this.context);
        }
    }
}

