/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

public class StructBuilderUtil {
    public static Struct jsonNodeToStruct(JsonNode document, Schema schema) {
        if (document == null) {
            return null;
        }
        return StructBuilderUtil.jsonNodeToStructInternal(document, schema);
    }

    private static Struct jsonNodeToStructInternal(JsonNode document, Schema schema) {
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            if (!document.has(field.name())) continue;
            struct.put(field.name(), StructBuilderUtil.getStructFieldValue(document.path(field.name()), field.schema()));
        }
        return struct;
    }

    private static Object getStructFieldValue(JsonNode node, Schema schema) {
        switch (node.getNodeType()) {
            case STRING: {
                return node.asText();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NUMBER: {
                if (node.isFloat()) {
                    return Float.valueOf(node.floatValue());
                }
                if (node.isDouble()) {
                    return node.asDouble();
                }
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                return node.decimalValue();
            }
            case ARRAY: {
                return StructBuilderUtil.getArrayAsList((ArrayNode)node, schema);
            }
            case OBJECT: {
                return StructBuilderUtil.jsonNodeToStructInternal(node, schema);
            }
        }
        return null;
    }

    private static List getArrayAsList(ArrayNode array, Schema schema) {
        ArrayList<Object> arrayObjects = new ArrayList<Object>(array.size());
        Iterator<JsonNode> elements = array.elements();
        while (elements.hasNext()) {
            arrayObjects.add(StructBuilderUtil.getStructFieldValue(elements.next(), schema.valueSchema()));
        }
        return arrayObjects;
    }
}

