/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.event;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.FlushEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.runtime.serializer.EnumSerializer;
import org.apache.flink.cdc.runtime.serializer.ListSerializer;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.event.DataChangeEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.SchemaChangeEventSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class EventSerializer
extends TypeSerializerSingleton<Event> {
    private static final long serialVersionUID = 1L;
    public static final EventSerializer INSTANCE = new EventSerializer();
    private final SchemaChangeEventSerializer schemaChangeEventSerializer = SchemaChangeEventSerializer.INSTANCE;
    private final ListSerializer<TableId> listSerializer = new ListSerializer<TableId>(TableIdSerializer.INSTANCE);
    private final EnumSerializer<EventClass> enumSerializer = new EnumSerializer<EventClass>(EventClass.class);
    private final TypeSerializer<DataChangeEvent> dataChangeEventSerializer = DataChangeEventSerializer.INSTANCE;
    private final EnumSerializer<SchemaChangeEventType> schemaChangeEventTypeEnumSerializer = new EnumSerializer<SchemaChangeEventType>(SchemaChangeEventType.class);

    public boolean isImmutableType() {
        return false;
    }

    public Event createInstance() {
        return new Event(){};
    }

    public Event copy(Event from) {
        if (from instanceof FlushEvent) {
            FlushEvent flushEvent = (FlushEvent)from;
            return new FlushEvent(flushEvent.getSourceSubTaskId(), this.listSerializer.copy(((FlushEvent)from).getTableIds()), this.schemaChangeEventTypeEnumSerializer.copy(flushEvent.getSchemaChangeEventType()));
        }
        if (from instanceof SchemaChangeEvent) {
            return this.schemaChangeEventSerializer.copy((SchemaChangeEvent)from);
        }
        if (from instanceof DataChangeEvent) {
            return (Event)this.dataChangeEventSerializer.copy((Object)((DataChangeEvent)from));
        }
        throw new UnsupportedOperationException("Unknown event type: " + from.toString());
    }

    public Event copy(Event from, Event reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Event record, DataOutputView target) throws IOException {
        if (record instanceof FlushEvent) {
            this.enumSerializer.serialize(EventClass.FLUSH_EVENT, target);
            target.writeInt(((FlushEvent)record).getSourceSubTaskId());
            this.listSerializer.serialize(((FlushEvent)record).getTableIds(), target);
            this.schemaChangeEventTypeEnumSerializer.serialize(((FlushEvent)record).getSchemaChangeEventType(), target);
        } else if (record instanceof SchemaChangeEvent) {
            this.enumSerializer.serialize(EventClass.SCHEME_CHANGE_EVENT, target);
            this.schemaChangeEventSerializer.serialize((SchemaChangeEvent)record, target);
        } else if (record instanceof DataChangeEvent) {
            this.enumSerializer.serialize(EventClass.DATA_CHANGE_EVENT, target);
            this.dataChangeEventSerializer.serialize((Object)((DataChangeEvent)record), target);
        } else {
            throw new UnsupportedOperationException("Unknown event type: " + record.toString());
        }
    }

    public Event deserialize(DataInputView source) throws IOException {
        EventClass eventClass = (EventClass)((Object)this.enumSerializer.deserialize(source));
        switch (eventClass) {
            case FLUSH_EVENT: {
                return new FlushEvent(source.readInt(), (List<TableId>)this.listSerializer.deserialize(source), (SchemaChangeEventType)((Object)this.schemaChangeEventTypeEnumSerializer.deserialize(source)));
            }
            case DATA_CHANGE_EVENT: {
                return (Event)this.dataChangeEventSerializer.deserialize(source);
            }
            case SCHEME_CHANGE_EVENT: {
                return this.schemaChangeEventSerializer.deserialize(source);
            }
        }
        throw new UnsupportedOperationException("Unknown event type: " + (Object)((Object)eventClass));
    }

    public Event deserialize(Event reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Event> snapshotConfiguration() {
        return new EventSerializerSnapshot();
    }

    static enum EventClass {
        DATA_CHANGE_EVENT,
        SCHEME_CHANGE_EVENT,
        FLUSH_EVENT;

    }

    public static final class EventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Event> {
        public EventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

