/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.event;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.runtime.serializer.ListSerializer;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.ColumnWithPositionSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class AddColumnEventSerializer
extends TypeSerializerSingleton<AddColumnEvent> {
    private static final long serialVersionUID = 1L;
    public static final AddColumnEventSerializer INSTANCE = new AddColumnEventSerializer();
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final ListSerializer<AddColumnEvent.ColumnWithPosition> columnsSerializer = new ListSerializer<AddColumnEvent.ColumnWithPosition>(ColumnWithPositionSerializer.INSTANCE);

    public boolean isImmutableType() {
        return false;
    }

    public AddColumnEvent createInstance() {
        return new AddColumnEvent(TableId.tableId("unknown"), Collections.emptyList());
    }

    public AddColumnEvent copy(AddColumnEvent from) {
        return new AddColumnEvent(from.tableId(), this.columnsSerializer.copy(from.getAddedColumns()));
    }

    public AddColumnEvent copy(AddColumnEvent from, AddColumnEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(AddColumnEvent record, DataOutputView target) throws IOException {
        this.tableIdSerializer.serialize(record.tableId(), target);
        this.columnsSerializer.serialize(record.getAddedColumns(), target);
    }

    public AddColumnEvent deserialize(DataInputView source) throws IOException {
        return new AddColumnEvent(this.tableIdSerializer.deserialize(source), (List<AddColumnEvent.ColumnWithPosition>)this.columnsSerializer.deserialize(source));
    }

    public AddColumnEvent deserialize(AddColumnEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<AddColumnEvent> snapshotConfiguration() {
        return new AddColumnEventSerializerSnapshot();
    }

    public static final class AddColumnEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<AddColumnEvent> {
        public AddColumnEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

