/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionCompiler;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;
import org.apache.flink.cdc.runtime.operators.transform.TransformFilter;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.MetadataColumns;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformFilterProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TransformFilterProcessor.class);
    private PostTransformChangeInfo tableInfo;
    private TransformFilter transformFilter;
    private String timezone;
    private TransformExpressionKey transformExpressionKey;
    private final transient List<Object> udfFunctionInstances;
    private transient ExpressionEvaluator expressionEvaluator;
    private final Map<String, SupportedMetadataColumn> supportedMetadataColumns;

    public TransformFilterProcessor(PostTransformChangeInfo tableInfo, TransformFilter transformFilter, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, Map<String, SupportedMetadataColumn> supportedMetadataColumns) {
        this.tableInfo = tableInfo;
        this.transformFilter = transformFilter;
        this.timezone = timezone;
        this.supportedMetadataColumns = supportedMetadataColumns;
        this.transformExpressionKey = this.generateTransformExpressionKey();
        this.udfFunctionInstances = udfFunctionInstances;
        this.expressionEvaluator = TransformExpressionCompiler.compileExpression(this.transformExpressionKey, udfDescriptors);
    }

    public static TransformFilterProcessor of(PostTransformChangeInfo tableInfo, TransformFilter transformFilter, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, SupportedMetadataColumn[] supportedMetadataColumns) {
        HashMap<String, SupportedMetadataColumn> supportedMetadataColumnsMap = new HashMap<String, SupportedMetadataColumn>();
        for (SupportedMetadataColumn supportedMetadataColumn : supportedMetadataColumns) {
            supportedMetadataColumnsMap.put(supportedMetadataColumn.getName(), supportedMetadataColumn);
        }
        return new TransformFilterProcessor(tableInfo, transformFilter, timezone, udfDescriptors, udfFunctionInstances, supportedMetadataColumnsMap);
    }

    public boolean process(BinaryRecordData record, long epochTime, String opType, Map<String, String> meta) {
        try {
            return (Boolean)this.expressionEvaluator.evaluate(this.generateParams(record, epochTime, opType, meta));
        }
        catch (InvocationTargetException e) {
            LOG.error("Table:{} filter:{} execute failed. {}", this.tableInfo.getName(), this.transformFilter.getExpression(), e);
            throw new RuntimeException(e);
        }
    }

    private Tuple2<List<String>, List<Class<?>>> generateArguments() {
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList argTypes = new ArrayList();
        String scriptExpression = this.transformFilter.getScriptExpression();
        List<Column> columns = this.tableInfo.getPreTransformedSchema().getColumns();
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>(this.transformFilter.getColumnNames());
        block0: for (String columnName : columnNames) {
            for (Column column : columns) {
                if (!column.getName().equals(columnName)) continue;
                argNames.add(columnName);
                argTypes.add(DataTypeConverter.convertOriginalClass(column.getType()));
                continue block0;
            }
        }
        MetadataColumns.METADATA_COLUMNS.stream().forEach(col -> {
            if (scriptExpression.contains((CharSequence)col.f0) && !argNames.contains(col.f0)) {
                argNames.add((String)col.f0);
                argTypes.add((Class<?>)col.f2);
            }
        });
        this.supportedMetadataColumns.keySet().forEach(colName -> {
            if (scriptExpression.contains((CharSequence)colName) && !argNames.contains(colName)) {
                argNames.add((String)colName);
                argTypes.add(this.supportedMetadataColumns.get(colName).getJavaClass());
            }
        });
        return Tuple2.of(argNames, argTypes);
    }

    private Object[] generateParams(BinaryRecordData record, long epochTime, String opType, Map<String, String> meta) {
        ArrayList<Object> params = new ArrayList<Object>();
        List<Column> columns = this.tableInfo.getPreTransformedSchema().getColumns();
        Tuple2<List<String>, List<Class<?>>> args = this.generateArguments();
        RecordData.FieldGetter[] fieldGetters = this.tableInfo.getPreTransformedFieldGetters();
        Iterator iterator = ((List)args.f0).iterator();
        block12: while (iterator.hasNext()) {
            String columnName;
            switch (columnName = (String)iterator.next()) {
                case "__namespace_name__": {
                    params.add(this.tableInfo.getNamespace());
                    continue block12;
                }
                case "__schema_name__": {
                    params.add(this.tableInfo.getSchemaName());
                    continue block12;
                }
                case "__table_name__": {
                    params.add(this.tableInfo.getTableName());
                    continue block12;
                }
                case "__data_event_type__": {
                    params.add(opType);
                    continue block12;
                }
            }
            if (this.supportedMetadataColumns.containsKey(columnName)) {
                params.add(this.supportedMetadataColumns.get(columnName).read(meta));
                continue;
            }
            for (int i = 0; i < columns.size(); ++i) {
                Column column = columns.get(i);
                if (!column.getName().equals(columnName)) continue;
                params.add(DataTypeConverter.convertToOriginal(fieldGetters[i].getFieldOrNull(record), column.getType()));
                continue block12;
            }
        }
        params.add(this.timezone);
        params.add(epochTime);
        params.addAll(this.udfFunctionInstances);
        return params.toArray();
    }

    private TransformExpressionKey generateTransformExpressionKey() {
        Tuple2<List<String>, List<Class<?>>> args = this.generateArguments();
        ((List)args.f0).add("__time_zone__");
        ((List)args.f1).add(String.class);
        ((List)args.f0).add("__epoch_time__");
        ((List)args.f1).add(Long.class);
        return TransformExpressionKey.of(JaninoCompiler.loadSystemFunction(this.transformFilter.getScriptExpression()), (List)args.f0, (List)args.f1, Boolean.class);
    }
}

