/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;

public interface AdminApiLookupStrategy<T> {
    public ApiRequestScope lookupScope(T var1);

    public AbstractRequest.Builder<?> buildRequest(Set<T> var1);

    public LookupResult<T> handleResponse(Set<T> var1, AbstractResponse var2);

    public static class LookupResult<K> {
        public final List<K> completedKeys;
        public final Map<K, Integer> mappedKeys;
        public final Map<K, Throwable> failedKeys;

        public LookupResult(Map<K, Throwable> failedKeys, Map<K, Integer> mappedKeys) {
            this(Collections.emptyList(), failedKeys, mappedKeys);
        }

        public LookupResult(List<K> completedKeys, Map<K, Throwable> failedKeys, Map<K, Integer> mappedKeys) {
            this.completedKeys = Collections.unmodifiableList(completedKeys);
            this.failedKeys = Collections.unmodifiableMap(failedKeys);
            this.mappedKeys = Collections.unmodifiableMap(mappedKeys);
        }

        static <K> LookupResult<K> empty() {
            return new LookupResult(Collections.emptyMap(), Collections.emptyMap());
        }

        static <K> LookupResult<K> failed(K key, Throwable exception) {
            return new LookupResult<K>(Collections.singletonMap(key, exception), Collections.emptyMap());
        }

        static <K> LookupResult<K> mapped(K key, Integer brokerId) {
            return new LookupResult(Collections.emptyMap(), Collections.singletonMap(key, brokerId));
        }
    }
}

