/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.options;

import java.time.Duration;
import org.apache.flink.cdc.connectors.base.options.SourceOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class JdbcSourceOptions
extends SourceOptions {
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the database server.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the database to use when connecting to the database server.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the database server.");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the database to monitor.");
    public static final ConfigOption<String> SCHEMA_NAME = ConfigOptions.key((String)"schema-name").stringType().noDefaultValue().withDescription("Schema name of the database to monitor.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the database to monitor.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    public static final ConfigOption<String> SERVER_ID = ConfigOptions.key((String)"server-id").stringType().noDefaultValue().withDescription("A numeric ID or a numeric ID range of this database client, The numeric ID syntax is like '5400', the numeric ID range syntax is like '5400-5408', The numeric ID range syntax is recommended when 'scan.incremental.snapshot.enabled' enabled. Every ID must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL  cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the database server before timing out.");
    public static final ConfigOption<Integer> CONNECTION_POOL_SIZE = ConfigOptions.key((String)"connection.pool.size").intType().defaultValue((Object)20).withDescription("The connection pool size.");
    public static final ConfigOption<Integer> CONNECT_MAX_RETRIES = ConfigOptions.key((String)"connect.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times that the connector should retry to build database server connection.");
    public static final ConfigOption<String> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.key-column").stringType().noDefaultValue().withDescription("The chunk key of table snapshot, captured tables are split into multiple chunks by a chunk key when read the snapshot of table.By default, the chunk key is the first column of the primary key and the chunk key is the RowId in oracle.");
}

