/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.DebeziumException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmVersionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmVersionUtil.class);
    private static final int FEATURE_VERSION = JvmVersionUtil.determineFeatureVersion();

    private JvmVersionUtil() {
    }

    private static int determineFeatureVersion() {
        int featureVersion;
        try {
            ClassLoader classLoader = JvmVersionUtil.class.getClassLoader();
            Class<?> versionClass = classLoader.loadClass("java.lang.Runtime$Version");
            MethodHandle versionHandle = MethodHandles.lookup().findStatic(Runtime.class, "version", MethodType.methodType(versionClass));
            MethodHandle versionListHandle = MethodHandles.lookup().findVirtual(versionClass, "version", MethodType.methodType(List.class));
            try {
                Object version = versionHandle.invoke();
                List versions = versionListHandle.bindTo(version).invoke();
                featureVersion = (Integer)versions.get(0);
            }
            catch (Throwable e) {
                throw new DebeziumException("Couldn't determine runtime version", e);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodError | NoSuchMethodException nsme) {
            String specVersion = System.getProperty("java.specification.version");
            featureVersion = Integer.parseInt(specVersion.substring(specVersion.indexOf(46) + 1));
        }
        LOGGER.debug("Determined Java version: {}", (Object)featureVersion);
        return featureVersion;
    }

    public static int getFeatureVersion() {
        return FEATURE_VERSION;
    }
}

