/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.transforms;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.header.Header;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.NonEmptyListValidator;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SimpleConfig;

public class DropHeaders<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Removes one or more headers from each record.";
    public static final String HEADERS_FIELD = "headers";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("headers", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "The name of the headers to be removed.");
    private Set<String> headers;

    @Override
    public R apply(R record) {
        ConnectHeaders updatedHeaders = new ConnectHeaders();
        for (Header header : ((ConnectRecord)record).headers()) {
            if (this.headers.contains(header.key())) continue;
            updatedHeaders.add(header);
        }
        return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp(), updatedHeaders);
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.headers = new HashSet<String>(config.getList(HEADERS_FIELD));
    }
}

