/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.util.ConnectorTaskId;

public class RestartPlan {
    private final RestartRequest request;
    private final ConnectorStateInfo stateInfo;
    private final Collection<ConnectorTaskId> idsToRestart;

    public RestartPlan(RestartRequest request, ConnectorStateInfo restartStateInfo) {
        this.request = Objects.requireNonNull(request, "RestartRequest name may not be null");
        this.stateInfo = Objects.requireNonNull(restartStateInfo, "ConnectorStateInfo name may not be null");
        this.idsToRestart = Collections.unmodifiableList(this.stateInfo.tasks().stream().filter(this::isRestarting).map(taskState -> new ConnectorTaskId(request.connectorName(), taskState.id())).collect(Collectors.toList()));
    }

    public String connectorName() {
        return this.request.connectorName();
    }

    public RestartRequest restartRequest() {
        return this.request;
    }

    public ConnectorStateInfo restartConnectorStateInfo() {
        return this.stateInfo;
    }

    public Collection<ConnectorTaskId> taskIdsToRestart() {
        return this.idsToRestart;
    }

    public boolean shouldRestartConnector() {
        return this.isRestarting(this.stateInfo.connector());
    }

    public boolean shouldRestartTasks() {
        return !this.taskIdsToRestart().isEmpty();
    }

    public int restartTaskCount() {
        return this.taskIdsToRestart().size();
    }

    public int totalTaskCount() {
        return this.stateInfo.tasks().size();
    }

    private boolean isRestarting(ConnectorStateInfo.AbstractState state) {
        return this.isRestarting(state.state());
    }

    private boolean isRestarting(String state) {
        return AbstractStatus.State.RESTARTING.toString().equalsIgnoreCase(state);
    }

    public String toString() {
        return this.shouldRestartConnector() ? String.format("plan to restart connector and %d of %d tasks for %s", this.restartTaskCount(), this.totalTaskCount(), this.request) : String.format("plan to restart %d of %d tasks for %s", this.restartTaskCount(), this.totalTaskCount(), this.request);
    }
}

