/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class DescribeTransactionsResponse
extends AbstractResponse {
    private final DescribeTransactionsResponseData data;

    public DescribeTransactionsResponse(DescribeTransactionsResponseData data) {
        super(ApiKeys.DESCRIBE_TRANSACTIONS);
        this.data = data;
    }

    @Override
    public DescribeTransactionsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (DescribeTransactionsResponseData.TransactionState transactionState : this.data.transactionStates()) {
            Errors error = Errors.forCode(transactionState.errorCode());
            this.updateErrorCounts(errorCounts, error);
        }
        return errorCounts;
    }

    public static DescribeTransactionsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeTransactionsResponse(new DescribeTransactionsResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }
}

