/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.header.Header;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.CompressionType;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.DefaultRecordsSend;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.LegacyRecord;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.Record;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.RecordBatch;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.Records;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.record.SimpleRecord;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.AbstractIterator;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;

public abstract class AbstractRecords
implements Records {
    private final Iterable<Record> records = this::recordsIterator;

    @Override
    public boolean hasMatchingMagic(byte magic) {
        for (RecordBatch recordBatch : this.batches()) {
            if (recordBatch.magic() == magic) continue;
            return false;
        }
        return true;
    }

    public RecordBatch firstBatch() {
        Iterator<? extends RecordBatch> iterator = this.batches().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public Iterable<Record> records() {
        return this.records;
    }

    public DefaultRecordsSend<Records> toSend() {
        return new DefaultRecordsSend<Records>(this);
    }

    private Iterator<Record> recordsIterator() {
        return new AbstractIterator<Record>(){
            private final Iterator<? extends RecordBatch> batches;
            private Iterator<Record> records;
            {
                this.batches = AbstractRecords.this.batches().iterator();
            }

            @Override
            protected Record makeNext() {
                if (this.records != null && this.records.hasNext()) {
                    return this.records.next();
                }
                if (this.batches.hasNext()) {
                    this.records = this.batches.next().iterator();
                    return this.makeNext();
                }
                return (Record)this.allDone();
            }
        };
    }

    public static int estimateSizeInBytes(byte magic, long baseOffset, CompressionType compressionType, Iterable<Record> records) {
        int size = 0;
        if (magic <= 1) {
            for (Record record : records) {
                size += 12 + LegacyRecord.recordSize(magic, record.key(), record.value());
            }
        } else {
            size = DefaultRecordBatch.sizeInBytes(baseOffset, records);
        }
        return AbstractRecords.estimateCompressedSizeInBytes(size, compressionType);
    }

    public static int estimateSizeInBytes(byte magic, CompressionType compressionType, Iterable<SimpleRecord> records) {
        int size = 0;
        if (magic <= 1) {
            for (SimpleRecord record : records) {
                size += 12 + LegacyRecord.recordSize(magic, record.key(), record.value());
            }
        } else {
            size = DefaultRecordBatch.sizeInBytes(records);
        }
        return AbstractRecords.estimateCompressedSizeInBytes(size, compressionType);
    }

    private static int estimateCompressedSizeInBytes(int size, CompressionType compressionType) {
        return compressionType == CompressionType.NONE ? size : Math.min(Math.max(size / 2, 1024), 65536);
    }

    public static int estimateSizeInBytesUpperBound(byte magic, CompressionType compressionType, byte[] key, byte[] value, Header[] headers) {
        return AbstractRecords.estimateSizeInBytesUpperBound(magic, compressionType, Utils.wrapNullable(key), Utils.wrapNullable(value), headers);
    }

    public static int estimateSizeInBytesUpperBound(byte magic, CompressionType compressionType, ByteBuffer key, ByteBuffer value, Header[] headers) {
        if (magic >= 2) {
            return DefaultRecordBatch.estimateBatchSizeUpperBound(key, value, headers);
        }
        if (compressionType != CompressionType.NONE) {
            return 12 + LegacyRecord.recordOverhead(magic) + LegacyRecord.recordSize(magic, key, value);
        }
        return 12 + LegacyRecord.recordSize(magic, key, value);
    }

    public static int recordBatchHeaderSizeInBytes(byte magic, CompressionType compressionType) {
        if (magic > 1) {
            return 61;
        }
        if (compressionType != CompressionType.NONE) {
            return 12 + LegacyRecord.recordOverhead(magic);
        }
        return 0;
    }
}

